/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.openfeign;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.cloud.alibaba.dubbo.metadata.RestMethodMetadata;
import org.springframework.cloud.alibaba.dubbo.openfeign.FeignMethodMetadata;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceExecutionContext;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceExecutionContextFactory;
import org.springframework.util.ClassUtils;

public class DubboInvocationHandler
implements InvocationHandler {
    private final Map<Method, FeignMethodMetadata> feignMethodMetadataMap;
    private final InvocationHandler defaultInvocationHandler;
    private final DubboGenericServiceExecutionContextFactory contextFactory;
    private final ClassLoader classLoader;

    public DubboInvocationHandler(Map<Method, FeignMethodMetadata> feignMethodMetadataMap, InvocationHandler defaultInvocationHandler, ClassLoader classLoader, DubboGenericServiceExecutionContextFactory contextFactory) {
        this.feignMethodMetadataMap = feignMethodMetadataMap;
        this.defaultInvocationHandler = defaultInvocationHandler;
        this.classLoader = classLoader;
        this.contextFactory = contextFactory;
    }

    @Override
    public Object invoke(Object proxy, Method feignMethod, Object[] args) throws Throwable {
        FeignMethodMetadata feignMethodMetadata = this.feignMethodMetadataMap.get(feignMethod);
        if (feignMethodMetadata == null) {
            return this.defaultInvocationHandler.invoke(proxy, feignMethod, args);
        }
        GenericService dubboGenericService = feignMethodMetadata.getDubboGenericService();
        RestMethodMetadata dubboRestMethodMetadata = feignMethodMetadata.getDubboRestMethodMetadata();
        RestMethodMetadata feignRestMethodMetadata = feignMethodMetadata.getFeignMethodMetadata();
        DubboGenericServiceExecutionContext context = this.contextFactory.create(dubboRestMethodMetadata, feignRestMethodMetadata, args);
        String methodName = context.getMethodName();
        String[] parameterTypes = context.getParameterTypes();
        Object[] parameters = context.getParameters();
        Object result = dubboGenericService.$invoke(methodName, parameterTypes, parameters);
        Class<?> returnType = this.getReturnType(dubboRestMethodMetadata);
        return PojoUtils.realize((Object)result, returnType);
    }

    private Class<?> getReturnType(RestMethodMetadata dubboRestMethodMetadata) {
        String returnType = dubboRestMethodMetadata.getReturnType();
        return ClassUtils.resolveClassName((String)returnType, (ClassLoader)this.classLoader);
    }
}

