/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.service;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataService;
import org.springframework.stereotype.Component;

@Component
public class DubboMetadataServiceExporter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ApplicationConfig applicationConfig;
    @Autowired
    private ObjectProvider<DubboMetadataService> dubboMetadataService;
    @Autowired
    private Supplier<ProtocolConfig> protocolConfigSupplier;
    @Value(value="${spring.application.name:${dubbo.application.name:application}}")
    private String currentApplicationName;
    private ServiceConfig<DubboMetadataService> serviceConfig;

    public List<URL> export() {
        if (this.serviceConfig == null || !this.serviceConfig.isExported()) {
            this.serviceConfig = new ServiceConfig();
            this.serviceConfig.setInterface(DubboMetadataService.class);
            this.serviceConfig.setVersion("1.0.0");
            this.serviceConfig.setGroup(this.currentApplicationName);
            this.serviceConfig.setRef(this.dubboMetadataService.getIfAvailable());
            this.serviceConfig.setApplication(this.applicationConfig);
            this.serviceConfig.setProtocol(this.protocolConfigSupplier.get());
            this.serviceConfig.export();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The Dubbo service[{}] has been exported.", (Object)this.serviceConfig.toString());
            }
        }
        return this.serviceConfig.getExportedUrls();
    }

    @PreDestroy
    public void unexport() {
        if (this.serviceConfig == null || this.serviceConfig.isUnexported()) {
            return;
        }
        this.serviceConfig.unexport();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The Dubbo service[{}] has been unexported.", (Object)this.serviceConfig.toString());
        }
    }
}

