/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceFactory;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataService;

class DubboMetadataServiceInvocationHandler
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GenericService genericService;

    public DubboMetadataServiceInvocationHandler(String serviceName, String version, DubboGenericServiceFactory dubboGenericServiceFactory) {
        this.genericService = dubboGenericServiceFactory.create(serviceName, DubboMetadataService.class, version);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue;
        block2: {
            returnValue = null;
            try {
                returnValue = this.genericService.$invoke(method.getName(), this.getParameterTypes(method), args);
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), e);
            }
        }
        return returnValue;
    }

    private String[] getParameterTypes(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return (String[])Stream.of(parameterTypes).map(Class::getName).toArray(String[]::new);
    }
}

