/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cache.Cache;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponseMetadata;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheProperties;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheUtils;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.CacheKeyGenerator;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.AfterCacheExchangeMutator;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.SetCacheDirectivesByMaxAgeAfterCacheExchangeMutator;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.SetMaxAgeHeaderAfterCacheExchangeMutator;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.SetResponseHeadersAfterCacheExchangeMutator;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.SetStatusCodeAfterCacheExchangeMutator;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResponseCacheManager {
    private static final Log LOGGER = LogFactory.getLog(ResponseCacheManager.class);
    private static final List<String> forbiddenCacheControlValues = Arrays.asList("private", "no-store");
    private static final String VARY_WILDCARD = "*";
    final CacheKeyGenerator cacheKeyGenerator;
    final List<AfterCacheExchangeMutator> afterCacheExchangeMutators;
    private final Cache cache;
    private final boolean ignoreNoCacheUpdate;
    private static final List<HttpStatusCode> statusesToCache = Arrays.asList(HttpStatus.OK, HttpStatus.PARTIAL_CONTENT, HttpStatus.MOVED_PERMANENTLY);

    @Deprecated
    public ResponseCacheManager(CacheKeyGenerator cacheKeyGenerator, Cache cache, Duration configuredTimeToLive) {
        this(cacheKeyGenerator, cache, configuredTimeToLive, new LocalResponseCacheProperties.RequestOptions());
    }

    public ResponseCacheManager(CacheKeyGenerator cacheKeyGenerator, Cache cache, Duration configuredTimeToLive, LocalResponseCacheProperties.RequestOptions requestOptions) {
        this.cacheKeyGenerator = cacheKeyGenerator;
        this.cache = cache;
        this.ignoreNoCacheUpdate = ResponseCacheManager.isSkipNoCacheUpdateActive(requestOptions);
        this.afterCacheExchangeMutators = List.of(new SetResponseHeadersAfterCacheExchangeMutator(), new SetStatusCodeAfterCacheExchangeMutator(), new SetMaxAgeHeaderAfterCacheExchangeMutator(configuredTimeToLive, Clock.systemDefaultZone(), this.ignoreNoCacheUpdate), new SetCacheDirectivesByMaxAgeAfterCacheExchangeMutator());
    }

    private static boolean isSkipNoCacheUpdateActive(LocalResponseCacheProperties.RequestOptions requestOptions) {
        return requestOptions != null && requestOptions.getNoCacheStrategy().equals((Object)LocalResponseCacheProperties.NoCacheStrategy.SKIP_UPDATE_CACHE_ENTRY);
    }

    public Optional<CachedResponse> getFromCache(ServerHttpRequest request, String metadataKey) {
        CachedResponseMetadata metadata = this.retrieveMetadata(metadataKey);
        String key = this.cacheKeyGenerator.generateKey(request, metadata != null ? metadata.varyOnHeaders() : Collections.emptyList());
        return this.getFromCache(key);
    }

    public Flux<DataBuffer> processFromUpstream(String metadataKey, ServerWebExchange exchange, Flux<DataBuffer> body) {
        ServerHttpResponse response = exchange.getResponse();
        CachedResponseMetadata metadata = new CachedResponseMetadata(response.getHeaders().getVary());
        String key = this.resolveKey(exchange, metadata.varyOnHeaders());
        CachedResponse.Builder cachedResponseBuilder = CachedResponse.create(response.getStatusCode()).headers(response.getHeaders());
        CachedResponse toProcess = cachedResponseBuilder.build();
        this.afterCacheExchangeMutators.forEach(processor -> processor.accept(exchange, toProcess));
        return body.map(dataBuffer -> {
            ByteBuffer byteBuffer = dataBuffer.toByteBuffer().asReadOnlyBuffer();
            cachedResponseBuilder.appendToBody(byteBuffer);
            return dataBuffer;
        }).doOnComplete(() -> {
            CachedResponse responseToCache = cachedResponseBuilder.timestamp(toProcess.timestamp()).build();
            this.saveMetadataInCache(metadataKey, metadata);
            this.saveInCache(key, responseToCache);
        });
    }

    private Optional<CachedResponse> getFromCache(String key) {
        CachedResponse cachedResponse;
        try {
            cachedResponse = (CachedResponse)this.cache.get((Object)key, CachedResponse.class);
        }
        catch (RuntimeException anyException) {
            LOGGER.error((Object)"Error reading from cache. Data will not come from cache.", (Throwable)anyException);
            cachedResponse = null;
        }
        return Optional.ofNullable(cachedResponse);
    }

    public String resolveMetadataKey(ServerWebExchange exchange) {
        return this.cacheKeyGenerator.generateMetadataKey(exchange.getRequest(), new String[0]);
    }

    public String resolveKey(ServerWebExchange exchange, List<String> varyOnHeaders) {
        return this.cacheKeyGenerator.generateKey(exchange.getRequest(), varyOnHeaders);
    }

    Mono<Void> processFromCache(ServerWebExchange exchange, String metadataKey, CachedResponse cachedResponse) {
        ServerHttpResponse response = exchange.getResponse();
        this.afterCacheExchangeMutators.forEach(processor -> processor.accept(exchange, cachedResponse));
        this.saveMetadataInCache(metadataKey, new CachedResponseMetadata(cachedResponse.headers().getVary()));
        return response.writeWith((Publisher)Flux.fromIterable(cachedResponse.body()).map(data -> response.bufferFactory().wrap(data)));
    }

    private CachedResponseMetadata retrieveMetadata(String metadataKey) {
        CachedResponseMetadata metadata;
        try {
            metadata = (CachedResponseMetadata)this.cache.get((Object)metadataKey, CachedResponseMetadata.class);
        }
        catch (RuntimeException anyException) {
            LOGGER.error((Object)"Error reading from cache. Metadata Data will not come from cache.", (Throwable)anyException);
            metadata = null;
        }
        return metadata;
    }

    boolean isResponseCacheable(ServerHttpResponse response) {
        return this.isStatusCodeToCache(response) && this.isCacheControlAllowed((HttpMessage)response) && !this.isVaryWildcard(response);
    }

    boolean isNoCacheRequestWithoutUpdate(ServerHttpRequest request) {
        return LocalResponseCacheUtils.isNoCacheRequest(request) && this.ignoreNoCacheUpdate;
    }

    private boolean isStatusCodeToCache(ServerHttpResponse response) {
        return statusesToCache.contains(response.getStatusCode());
    }

    boolean isRequestCacheable(ServerHttpRequest request) {
        return HttpMethod.GET.equals((Object)request.getMethod()) && !ResponseCacheManager.hasRequestBody(request) && this.isCacheControlAllowed((HttpMessage)request);
    }

    private boolean isVaryWildcard(ServerHttpResponse response) {
        HttpHeaders headers = response.getHeaders();
        List varyValues = headers.getOrEmpty((Object)"Vary");
        return varyValues.stream().anyMatch(VARY_WILDCARD::equals);
    }

    private boolean isCacheControlAllowed(HttpMessage request) {
        HttpHeaders headers = request.getHeaders();
        List cacheControlHeader = headers.getOrEmpty((Object)"Cache-Control");
        return cacheControlHeader.stream().noneMatch(forbiddenCacheControlValues::contains);
    }

    private static boolean hasRequestBody(ServerHttpRequest request) {
        return request.getHeaders().getContentLength() > 0L;
    }

    private void saveInCache(String cacheKey, CachedResponse cachedResponse) {
        try {
            this.cache.put((Object)cacheKey, (Object)cachedResponse);
        }
        catch (RuntimeException anyException) {
            LOGGER.error((Object)"Error writing into cache. Data will not be cached", (Throwable)anyException);
        }
    }

    private void saveMetadataInCache(String metadataKey, CachedResponseMetadata metadata) {
        try {
            this.cache.put((Object)metadataKey, (Object)metadata);
        }
        catch (RuntimeException anyException) {
            LOGGER.error((Object)"Error writing into cache. Data will not be cached", (Throwable)anyException);
        }
    }
}

