/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.squirrelframework.foundation.component.CompositePostProcessor;
import org.squirrelframework.foundation.component.SquirrelPostProcessor;

public class CompositePostProcessorImpl<T>
implements CompositePostProcessor<T> {
    List<SquirrelPostProcessor<? super T>> processors;

    public CompositePostProcessorImpl(SquirrelPostProcessor<? super T> ... processors) {
        this.processors = Lists.newArrayList((Object[])processors);
    }

    public CompositePostProcessorImpl() {
        this.processors = Lists.newArrayList();
    }

    @Override
    public void compose(SquirrelPostProcessor<? super T> processor) {
        if (!this.processors.contains(processor)) {
            this.processors.add(processor);
        }
    }

    @Override
    public void decompose(SquirrelPostProcessor<? super T> processor) {
        this.processors.remove(processor);
    }

    @Override
    public void clear() {
        this.processors.clear();
    }

    @Override
    public void postProcess(T component) {
        Object[] processArray;
        for (Object processor : processArray = this.processors.toArray()) {
            ((SquirrelPostProcessor)processor).postProcess(component);
        }
    }
}

