/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Actions;
import org.squirrelframework.foundation.fsm.StateMachine;

public class ActionsImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements Actions<T, S, E, C> {
    private final List<Action<T, S, E, C>> actions = Lists.newArrayList();
    private List<Action<T, S, E, C>> sortedActions;

    @Override
    public void add(Action<T, S, E, C> newAction) {
        if (newAction != null && !this.actions.contains(newAction)) {
            this.actions.add(newAction);
        }
    }

    @Override
    public void addAll(List<? extends Action<T, S, E, C>> newActions) {
        if (newActions != null && !newActions.isEmpty()) {
            for (Action<T, S, E, C> action : newActions) {
                if (action == null) continue;
                this.add(action);
            }
        }
    }

    @Override
    public List<Action<T, S, E, C>> getAll() {
        return this.getSortedAction();
    }

    private List<Action<T, S, E, C>> getSortedAction() {
        if (this.actions.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.sortedActions == null) {
            this.sortedActions = Lists.newArrayList(this.actions);
            Collections.sort(this.sortedActions, new Comparator<Action<T, S, E, C>>(){

                @Override
                public int compare(Action<T, S, E, C> o1, Action<T, S, E, C> o2) {
                    return o2.weight() - o1.weight();
                }
            });
            this.sortedActions = Collections.unmodifiableList(this.sortedActions);
        }
        return this.sortedActions;
    }

    @Override
    public void clear() {
        this.actions.clear();
        this.sortedActions = null;
    }
}

