/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.component.SquirrelInstanceProvider;
import org.squirrelframework.foundation.component.SquirrelPostProcessor;
import org.squirrelframework.foundation.component.SquirrelPostProcessorProvider;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.exception.SquirrelRuntimeException;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.ActionWrapper;
import org.squirrelframework.foundation.fsm.AnonymousAction;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.Converter;
import org.squirrelframework.foundation.fsm.ConverterProvider;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.ImmutableTransition;
import org.squirrelframework.foundation.fsm.MutableLinkedState;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.MutableTimedState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.MvelScriptManager;
import org.squirrelframework.foundation.fsm.StateCompositeType;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineBuilder;
import org.squirrelframework.foundation.fsm.StateMachineConfiguration;
import org.squirrelframework.foundation.fsm.TransitionType;
import org.squirrelframework.foundation.fsm.UntypedImmutableState;
import org.squirrelframework.foundation.fsm.UntypedMutableState;
import org.squirrelframework.foundation.fsm.UntypedStateMachine;
import org.squirrelframework.foundation.fsm.annotation.ContextEvent;
import org.squirrelframework.foundation.fsm.annotation.ContextInsensitive;
import org.squirrelframework.foundation.fsm.annotation.State;
import org.squirrelframework.foundation.fsm.annotation.StateMachineParameters;
import org.squirrelframework.foundation.fsm.annotation.States;
import org.squirrelframework.foundation.fsm.annotation.Transit;
import org.squirrelframework.foundation.fsm.annotation.Transitions;
import org.squirrelframework.foundation.fsm.builder.DeferBoundActionBuilder;
import org.squirrelframework.foundation.fsm.builder.EntryExitActionBuilder;
import org.squirrelframework.foundation.fsm.builder.ExternalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.From;
import org.squirrelframework.foundation.fsm.builder.InternalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.LocalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.MultiTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.On;
import org.squirrelframework.foundation.fsm.builder.To;
import org.squirrelframework.foundation.fsm.builder.When;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;
import org.squirrelframework.foundation.fsm.impl.DeferBoundActionInfo;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionImpl;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;
import org.squirrelframework.foundation.fsm.jmx.ManagementService;
import org.squirrelframework.foundation.util.DuplicateChecker;
import org.squirrelframework.foundation.util.ReflectUtils;

public class StateMachineBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements StateMachineBuilder<T, S, E, C> {
    private static final Logger logger;
    private final Map<S, MutableState<T, S, E, C>> states = Maps.newConcurrentMap();
    private final Class<? extends T> stateMachineImplClazz;
    private final Class<S> stateClazz;
    private final Class<E> eventClazz;
    private final Class<C> contextClazz;
    private boolean prepared = false;
    private final Constructor<? extends T> constructor;
    private final Method postConstructMethod;
    protected final Converter<S> stateConverter;
    protected final Converter<E> eventConverter;
    private final Class<?>[] methodCallParamTypes;
    private Map<String, String> stateAliasToDescription = null;
    private final MvelScriptManager scriptManager;
    private E startEvent;
    private E finishEvent;
    private E terminateEvent;
    private final ExecutionContext executionContext;
    private final List<DeferBoundActionInfo<T, S, E, C>> deferBoundActionInfoList = Lists.newArrayList();
    private boolean isScanAnnotations = true;
    private final Class<?>[] extraParamTypes;
    private StateMachineConfiguration defaultConfiguration = StateMachineConfiguration.getInstance();
    private ManagementService managementService;

    private StateMachineBuilderImpl(Class<? extends T> stateMachineImplClazz, Class<S> stateClazz, Class<E> eventClazz, Class<C> contextClazz, Class<?> ... extraParamTypes) {
        Constructor<? extends T> fsmConstructor;
        Class[] classArray;
        boolean contextInsensitive;
        Preconditions.checkArgument((boolean)this.isInstantiableType(stateMachineImplClazz), (Object)("The state machine class \"" + stateMachineImplClazz.getName() + "\" cannot be instantiated."));
        Preconditions.checkArgument((boolean)this.isStateMachineType(stateMachineImplClazz), (Object)("The implementation class of state machine \"" + stateMachineImplClazz.getName() + "\" must be extended from AbstractStateMachine.class."));
        this.stateMachineImplClazz = stateMachineImplClazz;
        this.extraParamTypes = extraParamTypes != null ? extraParamTypes : new Class[]{};
        StateMachineParameters genericsParameters = this.findAnnotation(StateMachineParameters.class);
        this.stateClazz = stateClazz == Object.class && genericsParameters != null ? genericsParameters.stateType() : stateClazz;
        this.eventClazz = eventClazz == Object.class && genericsParameters != null ? genericsParameters.eventType() : eventClazz;
        this.contextClazz = contextClazz == Object.class && genericsParameters != null ? genericsParameters.contextType() : contextClazz;
        this.stateConverter = ConverterProvider.INSTANCE.getConverter(this.stateClazz);
        this.eventConverter = ConverterProvider.INSTANCE.getConverter(this.eventClazz);
        this.scriptManager = SquirrelProvider.getInstance().newInstance(MvelScriptManager.class);
        boolean bl = contextInsensitive = this.findAnnotation(ContextInsensitive.class) != null;
        if (contextInsensitive) {
            Class[] classArray2 = new Class[3];
            classArray2[0] = this.stateClazz;
            classArray2[1] = this.stateClazz;
            classArray = classArray2;
            classArray2[2] = this.eventClazz;
        } else {
            Class[] classArray3 = new Class[4];
            classArray3[0] = this.stateClazz;
            classArray3[1] = this.stateClazz;
            classArray3[2] = this.eventClazz;
            classArray = classArray3;
            classArray3[3] = this.contextClazz;
        }
        this.methodCallParamTypes = classArray;
        try {
            fsmConstructor = ReflectUtils.getConstructor(stateMachineImplClazz, this.extraParamTypes);
        }
        catch (Exception e1) {
            try {
                fsmConstructor = ReflectUtils.getConstructor(stateMachineImplClazz, new Class[0]);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Cannot find matched constructor for '" + stateMachineImplClazz.getName() + "'.");
            }
        }
        this.constructor = fsmConstructor;
        Method postInit = null;
        try {
            postInit = ReflectUtils.getMethod(stateMachineImplClazz, "postConstruct", this.extraParamTypes);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.postConstructMethod = postInit;
        this.executionContext = new ExecutionContext(this.scriptManager, stateMachineImplClazz, this.methodCallParamTypes);
        this.defineContextEvent();
    }

    private void defineContextEvent() {
        ContextEvent contextEvent = this.findAnnotation(ContextEvent.class);
        if (contextEvent != null) {
            Preconditions.checkState((this.eventConverter != null ? 1 : 0) != 0, (Object)"Do not register event converter");
            if (!contextEvent.startEvent().isEmpty()) {
                this.defineStartEvent(this.eventConverter.convertFromString(contextEvent.startEvent()));
            }
            if (!contextEvent.finishEvent().isEmpty()) {
                this.defineFinishEvent(this.eventConverter.convertFromString(contextEvent.finishEvent()));
            }
            if (!contextEvent.terminateEvent().isEmpty()) {
                this.defineTerminateEvent(this.eventConverter.convertFromString(contextEvent.terminateEvent()));
            }
        }
    }

    private <M extends Annotation> M findAnnotation(final Class<M> annotationClass) {
        final AtomicReference genericsParametersRef = new AtomicReference();
        this.walkThroughStateMachineClass(new Function<Class<?>, Boolean>(){

            public Boolean apply(Class<?> input) {
                Object anno = input.getAnnotation(annotationClass);
                if (anno != null) {
                    genericsParametersRef.set(anno);
                    return false;
                }
                return true;
            }
        });
        Annotation genericsParameters = (Annotation)genericsParametersRef.get();
        return (M)genericsParameters;
    }

    private void checkState() {
        if (this.prepared) {
            throw new IllegalStateException("The state machine builder has been freezed and cannot be changed anymore.");
        }
    }

    @Override
    public ExternalTransitionBuilder<T, S, E, C> externalTransition() {
        this.checkState();
        return this.externalTransition(1);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> externalTransitions() {
        this.checkState();
        return this.transitions(1);
    }

    @Override
    public ExternalTransitionBuilder<T, S, E, C> transition() {
        this.checkState();
        return this.externalTransition(1);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> transitions() {
        this.checkState();
        return this.transitions(1);
    }

    @Override
    public DeferBoundActionBuilder<T, S, E, C> transit() {
        this.checkState();
        return FSM.newDeferBoundActionBuilder(this.deferBoundActionInfoList, this.executionContext);
    }

    @Override
    public LocalTransitionBuilder<T, S, E, C> localTransition() {
        this.checkState();
        return this.localTransition(1);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> localTransitions() {
        this.checkState();
        return this.localTransitions(1);
    }

    @Override
    public InternalTransitionBuilder<T, S, E, C> internalTransition() {
        this.checkState();
        return this.internalTransition(1);
    }

    @Override
    public ExternalTransitionBuilder<T, S, E, C> externalTransition(int priority) {
        this.checkState();
        return FSM.newExternalTransitionBuilder(this.states, priority, this.executionContext);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> externalTransitions(int priority) {
        this.checkState();
        return this.transitions(priority);
    }

    @Override
    public ExternalTransitionBuilder<T, S, E, C> transition(int priority) {
        this.checkState();
        return this.externalTransition(priority);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> transitions(int priority) {
        this.checkState();
        return FSM.newMultiTransitionBuilder(this.states, TransitionType.EXTERNAL, priority, this.executionContext);
    }

    @Override
    public LocalTransitionBuilder<T, S, E, C> localTransition(int priority) {
        this.checkState();
        return FSM.newLocalTransitionBuilder(this.states, priority, this.executionContext);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> localTransitions(int priority) {
        this.checkState();
        return FSM.newMultiTransitionBuilder(this.states, TransitionType.LOCAL, priority, this.executionContext);
    }

    @Override
    public InternalTransitionBuilder<T, S, E, C> internalTransition(int priority) {
        this.checkState();
        return FSM.newInternalTransitionBuilder(this.states, priority, this.executionContext);
    }

    private void addStateEntryExitMethodCallAction(String methodName, Class<?>[] parameterTypes, MutableState<T, S, E, C> mutableState, boolean isEntryAction) {
        Method method = StateMachineBuilderImpl.findMethodCallActionInternal(this.stateMachineImplClazz, methodName, parameterTypes);
        if (method != null) {
            int weight = -10;
            if (methodName.startsWith("before")) {
                weight = 100;
            } else if (methodName.startsWith("after")) {
                weight = -100;
            }
            MethodCallActionImpl methodCallAction = FSM.newMethodCallAction(method, weight, this.executionContext);
            if (isEntryAction) {
                mutableState.addEntryAction(methodCallAction);
            } else {
                mutableState.addExitAction(methodCallAction);
            }
        }
    }

    private void addTransitionMethodCallAction(String methodName, Class<?>[] parameterTypes, MutableTransition<T, S, E, C> mutableTransition) {
        Method method = StateMachineBuilderImpl.findMethodCallActionInternal(this.stateMachineImplClazz, methodName, parameterTypes);
        if (method != null) {
            MethodCallActionImpl methodCallAction = FSM.newMethodCallAction(method, -10, this.executionContext);
            mutableTransition.addAction(methodCallAction);
        }
    }

    private boolean isDeferBoundAction(Transit transit) {
        return "*".equals(transit.from()) || "*".equals(transit.to()) || "*".equals(transit.on());
    }

    private Action<T, S, E, C> warpConditionalAction(Action<T, S, E, C> action, final Condition<C> condition) {
        return new ActionWrapper<T, S, E, C>(action){

            @Override
            public void execute(S from, S to, E event, C context, T stateMachine) {
                if (condition.isSatisfied(context)) {
                    super.execute(from, to, event, context, stateMachine);
                }
            }
        };
    }

    private void buildDeferBoundAction(Transit transit) {
        Object from = "*".equals(transit.from()) ? null : (Object)this.stateConverter.convertFromString(this.parseStateId(transit.from()));
        Object to = "*".equals(transit.to()) ? null : (Object)this.stateConverter.convertFromString(this.parseStateId(transit.to()));
        Object event = "*".equals(transit.on()) ? null : (Object)this.eventConverter.convertFromString(transit.on());
        DeferBoundActionInfo deferBoundActionInfo = new DeferBoundActionInfo(from, to, event);
        if (!transit.callMethod().isEmpty()) {
            Condition condition;
            Action action = FSM.newMethodCallActionProxy(transit.callMethod(), this.executionContext);
            if (!transit.whenMvel().isEmpty()) {
                condition = FSM.newMvelCondition(transit.whenMvel(), this.scriptManager);
                action = this.warpConditionalAction(action, condition);
            }
            if (transit.when() != Conditions.Always.class) {
                condition = ReflectUtils.newInstance(transit.when());
                action = this.warpConditionalAction(action, condition);
            }
            deferBoundActionInfo.setActions(Collections.singletonList(action));
        }
        this.deferBoundActionInfoList.add(deferBoundActionInfo);
    }

    private void buildDeclareTransition(Transit transit) {
        On whenBuilder;
        To<T, S, E, C> toBuilder;
        Object transitionBuilder;
        if (transit == null) {
            return;
        }
        Preconditions.checkState((this.stateConverter != null ? 1 : 0) != 0, (Object)"Do not register state converter");
        Preconditions.checkState((this.eventConverter != null ? 1 : 0) != 0, (Object)"Do not register event converter");
        if (this.isDeferBoundAction(transit)) {
            this.buildDeferBoundAction(transit);
            return;
        }
        Preconditions.checkArgument((boolean)this.isInstantiableType(transit.when()), (Object)"Condition 'when' should be concrete class or static inner class.");
        Preconditions.checkArgument((transit.type() != TransitionType.INTERNAL || transit.from().equals(transit.to()) ? 1 : 0) != 0, (Object)"Internal transition must transit to the same source state.");
        S fromState = this.stateConverter.convertFromString(this.parseStateId(transit.from()));
        Preconditions.checkNotNull(fromState, (Object)("Cannot convert state of name \"" + fromState + "\"."));
        S toState = this.stateConverter.convertFromString(this.parseStateId(transit.to()));
        E event = this.eventConverter.convertFromString(transit.on());
        Preconditions.checkNotNull(event, (Object)("Cannot convert event of name \"" + event + "\"."));
        if (this.states.get(fromState) != null) {
            MutableState<T, S, E, C> theFromState = this.states.get(fromState);
            for (ImmutableTransition t : theFromState.getAllTransitions()) {
                if (!t.isMatch(fromState, toState, event, transit.priority(), transit.when(), transit.type())) continue;
                MutableTransition mutableTransition = (MutableTransition)t;
                String callMethodExpression = transit.callMethod();
                if (callMethodExpression != null && callMethodExpression.length() > 0) {
                    MethodCallActionProxyImpl methodCallAction = FSM.newMethodCallActionProxy(callMethodExpression, this.executionContext);
                    mutableTransition.addAction(methodCallAction);
                }
                return;
            }
        }
        if (transit.type() == TransitionType.INTERNAL) {
            transitionBuilder = FSM.newInternalTransitionBuilder(this.states, transit.priority(), this.executionContext);
            toBuilder = transitionBuilder.within(fromState);
        } else {
            transitionBuilder = transit.type() == TransitionType.LOCAL ? FSM.newLocalTransitionBuilder(this.states, transit.priority(), this.executionContext) : FSM.newExternalTransitionBuilder(this.states, transit.priority(), this.executionContext);
            From fromBuilder = transitionBuilder.from(fromState);
            boolean isTargetFinal = transit.isTargetFinal() || FSM.getState(this.states, toState).isFinalState();
            toBuilder = isTargetFinal ? fromBuilder.toFinal(toState) : fromBuilder.to(toState);
        }
        On onBuilder = toBuilder.on(event);
        Condition c = null;
        try {
            if (transit.when() != Conditions.Always.class) {
                Constructor<? extends Condition> constructor = transit.when().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                c = constructor.newInstance(new Object[0]);
            } else if (StringUtils.isNotEmpty((CharSequence)transit.whenMvel())) {
                c = FSM.newMvelCondition(transit.whenMvel(), this.scriptManager);
            }
        }
        catch (Exception e) {
            logger.error("Instantiate Condition \"" + transit.when().getName() + "\" failed.");
            c = Conditions.never();
        }
        When when = whenBuilder = c != null ? onBuilder.when(c) : onBuilder;
        if (!Strings.isNullOrEmpty((String)transit.callMethod())) {
            MethodCallActionProxyImpl methodCallAction = FSM.newMethodCallActionProxy(transit.callMethod(), this.executionContext);
            whenBuilder.perform(methodCallAction);
        }
    }

    private String parseStateId(String value) {
        return value != null && value.startsWith("#") ? this.stateAliasToDescription.get(value.substring(1)) : value;
    }

    private void buildDeclareState(State state) {
        MethodCallActionProxyImpl methodCallAction;
        if (state == null) {
            return;
        }
        Preconditions.checkState((this.stateConverter != null ? 1 : 0) != 0, (Object)"Do not register state converter");
        S stateId = this.stateConverter.convertFromString(state.name());
        Preconditions.checkNotNull(stateId, (Object)("Cannot convert state of name \"" + state.name() + "\"."));
        MutableState<T, S, E, C> newState = this.defineState(stateId);
        newState.setCompositeType(state.compositeType());
        if (!newState.isParallelState()) {
            newState.setHistoryType(state.historyType());
        }
        newState.setFinal(state.isFinal());
        if (!Strings.isNullOrEmpty((String)state.parent())) {
            S parentStateId = this.stateConverter.convertFromString(this.parseStateId(state.parent()));
            MutableState<T, S, E, C> parentState = this.defineState(parentStateId);
            newState.setParentState(parentState);
            parentState.addChildState(newState);
            if (!parentState.isParallelState() && state.initialState()) {
                parentState.setInitialState(newState);
            }
        }
        if (!Strings.isNullOrEmpty((String)state.entryCallMethod())) {
            methodCallAction = FSM.newMethodCallActionProxy(state.entryCallMethod(), this.executionContext);
            this.onEntry(stateId).perform(methodCallAction);
        }
        if (!Strings.isNullOrEmpty((String)state.exitCallMethod())) {
            methodCallAction = FSM.newMethodCallActionProxy(state.exitCallMethod(), this.executionContext);
            this.onExit(stateId).perform(methodCallAction);
        }
        this.rememberStateAlias(state);
    }

    private void rememberStateAlias(State state) {
        if (Strings.isNullOrEmpty((String)state.alias())) {
            return;
        }
        if (this.stateAliasToDescription == null) {
            this.stateAliasToDescription = Maps.newHashMap();
        }
        if (this.stateAliasToDescription.containsKey(state.alias())) {
            throw new RuntimeException("Cannot define duplicate state alias \"" + state.alias() + "\" for state \"" + state.name() + "\" and " + this.stateAliasToDescription.get(state.alias()) + "\".");
        }
        this.stateAliasToDescription.put(state.alias(), state.name());
    }

    private void walkThroughStateMachineClass(Function<Class<?>, Boolean> func) {
        Class k;
        boolean isContinue;
        Stack stack = new Stack();
        stack.push(this.stateMachineImplClazz);
        while (!stack.isEmpty() && (isContinue = ((Boolean)func.apply((Object)(k = (Class)stack.pop()))).booleanValue())) {
            for (Class<?> i : k.getInterfaces()) {
                if (!this.isStateMachineInterface(i)) continue;
                stack.push(i);
            }
            if (!this.isStateMachineType(k.getSuperclass())) continue;
            stack.push(k.getSuperclass());
        }
    }

    private void verifyStateMachineDefinition() {
        for (MutableState<T, S, E, C> state : this.states.values()) {
            state.verify();
        }
    }

    private void installDeferBoundActions() {
        if (this.deferBoundActionInfoList.isEmpty()) {
            return;
        }
        for (DeferBoundActionInfo<T, S, E, C> deferBoundActionInfo : this.deferBoundActionInfoList) {
            this.installDeferBoundAction(deferBoundActionInfo);
        }
    }

    private void installDeferBoundAction(DeferBoundActionInfo<T, S, E, C> deferBoundActionInfo) {
        for (MutableState<T, S, E, C> mutableState : this.states.values()) {
            if (!deferBoundActionInfo.isFromStateMatch(mutableState.getStateId())) continue;
            for (ImmutableTransition transition : mutableState.getAllTransitions()) {
                if (!deferBoundActionInfo.isToStateMatch(transition.getTargetState().getStateId()) || !deferBoundActionInfo.isEventStateMatch(transition.getEvent())) continue;
                MutableTransition mutableTransition = (MutableTransition)transition;
                mutableTransition.addActions(deferBoundActionInfo.getActions());
            }
        }
    }

    private synchronized void prepare() {
        if (this.prepared) {
            return;
        }
        if (this.isScanAnnotations) {
            this.walkThroughStateMachineClass(new DeclareStateFunction());
            this.walkThroughStateMachineClass(new DeclareTransitionFunction());
            this.installDeferBoundActions();
        }
        this.installExtensionMethods();
        this.prioritizeTransitions();
        this.installFinalStateActions();
        this.verifyStateMachineDefinition();
        this.proxyUntypedStates();
        this.prepared = true;
    }

    private void proxyUntypedStates() {
        if (UntypedStateMachine.class.isAssignableFrom(this.stateMachineImplClazz)) {
            HashMap untypedStates = Maps.newHashMap();
            for (final MutableState<T, S, E, C> state : this.states.values()) {
                UntypedMutableState untypedState = (UntypedMutableState)Proxy.newProxyInstance(UntypedMutableState.class.getClassLoader(), new Class[]{UntypedMutableState.class, UntypedImmutableState.class}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("getStateId")) {
                            return state.getStateId();
                        }
                        if (method.getName().equals("getThis")) {
                            return state.getThis();
                        }
                        if (method.getName().equals("equals")) {
                            return state.equals(args[0]);
                        }
                        if (method.getName().equals("hashCode")) {
                            return state.hashCode();
                        }
                        return method.invoke((Object)state, args);
                    }
                });
                untypedStates.put(state.getStateId(), MutableState.class.cast(untypedState));
            }
            this.states.clear();
            this.states.putAll(untypedStates);
        }
    }

    private String[] getEntryExitStateMethodNames(ImmutableState<T, S, E, C> state, boolean isEntry) {
        String prefix = isEntry ? "entry" : "exit";
        String postfix = isEntry ? "EntryAny" : "ExitAny";
        return new String[]{"before" + postfix, prefix + (this.stateConverter != null && !state.isFinalState() ? this.stateConverter.convertToString(state.getStateId()) : StringUtils.capitalize((String)state.toString())), "after" + postfix};
    }

    private String[] getTransitionMethodNames(ImmutableTransition<T, S, E, C> transition) {
        ImmutableState<T, S, E, C> fromState = transition.getSourceState();
        ImmutableState<T, S, E, C> toState = transition.getTargetState();
        E event = transition.getEvent();
        String fromStateName = this.stateConverter != null ? this.stateConverter.convertToString(fromState.getStateId()) : StringUtils.capitalize((String)fromState.toString());
        String toStateName = this.stateConverter != null && !toState.isFinalState() ? this.stateConverter.convertToString(toState.getStateId()) : StringUtils.capitalize((String)toState.toString());
        String eventName = this.eventConverter != null ? this.eventConverter.convertToString(event) : StringUtils.capitalize((String)event.toString());
        String conditionName = transition.getCondition().name();
        return new String[]{"transitFrom" + fromStateName + "To" + toStateName + "On" + eventName + "When" + conditionName, "transitFrom" + fromStateName + "To" + toStateName + "On" + eventName, "transitFromAnyTo" + toStateName + "On" + eventName, "transitFrom" + fromStateName + "ToAnyOn" + eventName, "transitFrom" + fromStateName + "To" + toStateName, "on" + eventName};
    }

    private void installExtensionMethods() {
        for (MutableState<T, S, E, C> state : this.states.values()) {
            String[] entryMethodCallCandidates;
            String[] exitMethodCallCandidates;
            if (state.isFinalState()) continue;
            for (String exitMethodCallCandidate : exitMethodCallCandidates = this.getEntryExitStateMethodNames(state, false)) {
                this.addStateEntryExitMethodCallAction(exitMethodCallCandidate, this.methodCallParamTypes, state, false);
            }
            for (ImmutableTransition transition : state.getAllTransitions()) {
                String[] transitionMethodCallCandidates;
                for (String transitionMethodCallCandidate : transitionMethodCallCandidates = this.getTransitionMethodNames(transition)) {
                    this.addTransitionMethodCallAction(transitionMethodCallCandidate, this.methodCallParamTypes, (MutableTransition)transition);
                }
            }
            for (String entryMethodCallCandidate : entryMethodCallCandidates = this.getEntryExitStateMethodNames(state, true)) {
                this.addStateEntryExitMethodCallAction(entryMethodCallCandidate, this.methodCallParamTypes, state, true);
            }
        }
    }

    private void prioritizeTransitions() {
        for (MutableState<T, S, E, C> state : this.states.values()) {
            if (state.isFinalState()) continue;
            state.prioritizeTransitions();
        }
    }

    private void installFinalStateActions() {
        for (MutableState<T, S, E, C> state : this.states.values()) {
            if (!state.isFinalState()) continue;
            state.addExitAction(new AnonymousAction<T, S, E, C>(){

                @Override
                public void execute(S from, S to, E event, C context, T stateMachine) {
                    throw new IllegalStateException("Final state cannot be exited anymore.");
                }

                @Override
                public String name() {
                    return "__FINAL_STATE_ACTION_GUARD";
                }
            });
        }
    }

    private boolean isInstantiableType(Class<?> type) {
        return type != null && !type.isInterface() && !Modifier.isAbstract(type.getModifiers()) && (type.getEnclosingClass() == null || Modifier.isStatic(type.getModifiers()));
    }

    private boolean isStateMachineType(Class<?> stateMachineClazz) {
        return stateMachineClazz != null && AbstractStateMachine.class != stateMachineClazz && AbstractStateMachine.class.isAssignableFrom(stateMachineClazz);
    }

    private boolean isStateMachineInterface(Class<?> stateMachineClazz) {
        return stateMachineClazz != null && stateMachineClazz.isInterface() && StateMachine.class.isAssignableFrom(stateMachineClazz);
    }

    private static Method searchMethod(Class<?> targetClass, Class<?> superClass, String methodName, Class<?>[] parameterTypes) {
        if (superClass.isAssignableFrom(targetClass)) {
            Class<?> clazz = targetClass;
            while (!superClass.equals(clazz)) {
                try {
                    return clazz.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    clazz = clazz.getSuperclass();
                }
            }
        }
        return null;
    }

    static Method findMethodCallActionInternal(Class<?> target, String methodName, Class<?>[] parameterTypes) {
        return StateMachineBuilderImpl.searchMethod(target, AbstractStateMachine.class, methodName, parameterTypes);
    }

    @Override
    public T newStateMachine(S initialStateId) {
        return this.newStateMachine(initialStateId, new Object[0]);
    }

    @Override
    public T newStateMachine(S initialStateId, Object ... extraParams) {
        return this.newStateMachine(initialStateId, this.defaultConfiguration, extraParams);
    }

    @Override
    public T newStateMachine(S initialStateId, StateMachineConfiguration configuration, Object ... extraParams) {
        StateMachine stateMachine;
        if (!this.prepared) {
            this.prepare();
        }
        if (!this.isValidState(initialStateId)) {
            throw new IllegalArgumentException(this.getClass() + " cannot find Initial state '" + initialStateId + "' in state machine.");
        }
        Class<?>[] constParamTypes = this.constructor.getParameterTypes();
        try {
            stateMachine = constParamTypes == null || constParamTypes.length == 0 ? (StateMachine)ReflectUtils.newInstance(this.constructor) : (StateMachine)ReflectUtils.newInstance(this.constructor, extraParams);
        }
        catch (SquirrelRuntimeException e) {
            throw new IllegalStateException("New state machine instance failed.", e.getTargetException());
        }
        final AbstractStateMachine stateMachineImpl = (AbstractStateMachine)stateMachine;
        stateMachineImpl.prePostConstruct(initialStateId, this.states, configuration, new Runnable(){

            @Override
            public void run() {
                stateMachineImpl.setStartEvent(StateMachineBuilderImpl.this.startEvent);
                stateMachineImpl.setFinishEvent(StateMachineBuilderImpl.this.finishEvent);
                stateMachineImpl.setTerminateEvent(StateMachineBuilderImpl.this.terminateEvent);
                stateMachineImpl.setExtraParamTypes(StateMachineBuilderImpl.this.extraParamTypes);
                stateMachineImpl.setTypeOfStateMachine(StateMachineBuilderImpl.this.stateMachineImplClazz);
                stateMachineImpl.setTypeOfState(StateMachineBuilderImpl.this.stateClazz);
                stateMachineImpl.setTypeOfEvent(StateMachineBuilderImpl.this.eventClazz);
                stateMachineImpl.setTypeOfContext(StateMachineBuilderImpl.this.contextClazz);
                stateMachineImpl.setScriptManager(StateMachineBuilderImpl.this.scriptManager);
            }
        });
        if (this.postConstructMethod != null && this.extraParamTypes.length == extraParams.length) {
            try {
                ReflectUtils.invoke(this.postConstructMethod, stateMachine, extraParams);
            }
            catch (SquirrelRuntimeException e) {
                throw new IllegalStateException("Invoke state machine postConstruct method failed.", e.getTargetException());
            }
        }
        this.postProcessStateMachine(this.stateMachineImplClazz, stateMachine);
        if (configuration.isRemoteMonitorEnabled()) {
            this.getManagementService().register(stateMachine);
        }
        return (T)stateMachine;
    }

    private ManagementService getManagementService() {
        if (this.managementService == null) {
            this.managementService = new ManagementService();
        }
        return this.managementService;
    }

    private boolean isValidState(S initialStateId) {
        return initialStateId != null && this.states.get(initialStateId) != null;
    }

    private T postProcessStateMachine(Class<T> clz, T component) {
        if (component != null) {
            List<SquirrelPostProcessor<T>> postProcessors = SquirrelPostProcessorProvider.getInstance().getCallablePostProcessors(clz);
            for (SquirrelPostProcessor<T> postProcessor : postProcessors) {
                postProcessor.postProcess(component);
            }
        }
        return component;
    }

    @Override
    public MutableState<T, S, E, C> defineState(S stateId) {
        this.checkState();
        return FSM.getState(this.states, stateId);
    }

    @Override
    public MutableState<T, S, E, C> defineFinalState(S stateId) {
        this.checkState();
        MutableState<T, S, E, C> newState = this.defineState(stateId);
        newState.setFinal(true);
        return newState;
    }

    @Override
    public MutableState<T, S, E, C> defineLinkedState(S stateId, final StateMachineBuilder<? extends StateMachine<?, S, E, C>, S, E, C> linkedStateMachineBuilder, final S initialLinkedState, final Object ... extraParams) {
        this.checkState();
        MutableState<T, S, E, C> state = this.states.get(stateId);
        if (state == null) {
            MutableLinkedState linkedState = FSM.newLinkedState(stateId);
            SquirrelInstanceProvider provider = new SquirrelInstanceProvider<StateMachine<?, S, E, C>>(){

                @Override
                public StateMachine<?, S, E, C> get() {
                    return linkedStateMachineBuilder.newStateMachine(initialLinkedState, extraParams);
                }
            };
            linkedState.setLinkedStateMachineProvider(provider);
            this.states.put(stateId, linkedState);
            state = linkedState;
        }
        return state;
    }

    @Override
    public MutableState<T, S, E, C> defineTimedState(S stateId, long initialDelay, long timeInterval, E autoEvent, C autoContext) {
        this.checkState();
        MutableState<T, S, E, C> state = this.states.get(stateId);
        if (state == null) {
            MutableTimedState timedState = FSM.newTimedState(stateId);
            timedState.setAutoFireContext(autoContext);
            timedState.setAutoFireEvent(autoEvent);
            timedState.setInitialDelay(initialDelay);
            timedState.setTimeInterval(timeInterval);
            this.states.put(stateId, timedState);
            state = timedState;
        }
        return state;
    }

    @Override
    public void defineSequentialStatesOn(S parentStateId, S ... childStateIds) {
        this.checkState();
        this.defineSequentialStatesOn(parentStateId, HistoryType.NONE, childStateIds);
    }

    @Override
    public void defineNoInitSequentialStatesOn(S parentStateId, S ... childStateIds) {
        this.checkState();
        this.defineNoInitSequentialStatesOn(parentStateId, HistoryType.NONE, childStateIds);
    }

    @Override
    public void defineNoInitSequentialStatesOn(S parentStateId, HistoryType historyType, S ... childStateIds) {
        this.checkState();
        this.defineChildStatesOn(parentStateId, StateCompositeType.SEQUENTIAL, historyType, true, childStateIds);
    }

    @Override
    public void defineSequentialStatesOn(S parentStateId, HistoryType historyType, S ... childStateIds) {
        this.checkState();
        this.defineChildStatesOn(parentStateId, StateCompositeType.SEQUENTIAL, historyType, false, childStateIds);
    }

    @Override
    public void defineParallelStatesOn(S parentStateId, S ... childStateIds) {
        this.checkState();
        this.defineChildStatesOn(parentStateId, StateCompositeType.PARALLEL, HistoryType.NONE, true, childStateIds);
    }

    private void defineChildStatesOn(S parentStateId, StateCompositeType compositeType, HistoryType historyType, boolean ignoreInitialState, S ... childStateIds) {
        this.checkState();
        if (childStateIds != null && childStateIds.length > 0) {
            MutableState<T, S, E, C> parentState = FSM.getState(this.states, parentStateId);
            parentState.setCompositeType(compositeType);
            parentState.setHistoryType(historyType);
            int size = childStateIds.length;
            for (int i = 0; i < size; ++i) {
                MutableState<T, S, E, C> childState = FSM.getState(this.states, childStateIds[i]);
                if (!ignoreInitialState && i == 0) {
                    parentState.setInitialState(childState);
                }
                childState.setParentState(parentState);
                parentState.addChildState(childState);
            }
        }
    }

    @Override
    public EntryExitActionBuilder<T, S, E, C> onEntry(S stateId) {
        this.checkState();
        MutableState<T, S, E, C> state = FSM.getState(this.states, stateId);
        return FSM.newEntryExitActionBuilder(state, true, this.executionContext);
    }

    @Override
    public EntryExitActionBuilder<T, S, E, C> onExit(S stateId) {
        this.checkState();
        MutableState<T, S, E, C> state = FSM.getState(this.states, stateId);
        return FSM.newEntryExitActionBuilder(state, false, this.executionContext);
    }

    @Override
    public void defineFinishEvent(E finishEvent) {
        this.checkState();
        this.finishEvent = finishEvent;
    }

    @Override
    public void defineStartEvent(E startEvent) {
        this.checkState();
        this.startEvent = startEvent;
    }

    @Override
    public void defineTerminateEvent(E terminateEvent) {
        this.checkState();
        this.terminateEvent = terminateEvent;
    }

    void setScanAnnotations(boolean isScanAnnotations) {
        this.isScanAnnotations = isScanAnnotations;
    }

    @Override
    public void setStateMachineConfiguration(StateMachineConfiguration configure) {
        this.checkState();
        this.defaultConfiguration = configure;
    }

    static {
        DuplicateChecker.checkDuplicate(StateMachineBuilder.class);
        logger = LoggerFactory.getLogger(StateMachineBuilderImpl.class);
    }

    private class DeclareStateFunction
    implements Function<Class<?>, Boolean> {
        private DeclareStateFunction() {
        }

        public Boolean apply(Class<?> k) {
            StateMachineBuilderImpl.this.buildDeclareState(k.getAnnotation(State.class));
            States states = k.getAnnotation(States.class);
            if (states != null && states.value() != null) {
                for (State s : states.value()) {
                    StateMachineBuilderImpl.this.buildDeclareState(s);
                }
            }
            return true;
        }
    }

    private class DeclareTransitionFunction
    implements Function<Class<?>, Boolean> {
        private DeclareTransitionFunction() {
        }

        public Boolean apply(Class<?> k) {
            StateMachineBuilderImpl.this.buildDeclareTransition(k.getAnnotation(Transit.class));
            Transitions transitions = k.getAnnotation(Transitions.class);
            if (transitions != null && transitions.value() != null) {
                for (Transit t : transitions.value()) {
                    StateMachineBuilderImpl.this.buildDeclareTransition(t);
                }
            }
            return true;
        }
    }
}

