/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.List;
import java.util.Map;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.TransitionType;
import org.squirrelframework.foundation.fsm.builder.ExternalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.From;
import org.squirrelframework.foundation.fsm.builder.InternalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.LocalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.On;
import org.squirrelframework.foundation.fsm.builder.To;
import org.squirrelframework.foundation.fsm.builder.When;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;

class TransitionBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements ExternalTransitionBuilder<T, S, E, C>,
InternalTransitionBuilder<T, S, E, C>,
LocalTransitionBuilder<T, S, E, C>,
From<T, S, E, C>,
To<T, S, E, C>,
On<T, S, E, C>,
SquirrelComponent {
    private final Map<S, MutableState<T, S, E, C>> states;
    private MutableState<T, S, E, C> sourceState;
    private MutableState<T, S, E, C> targetState;
    private MutableTransition<T, S, E, C> transition;
    private final TransitionType transitionType;
    private final int priority;
    private final ExecutionContext executionContext;

    TransitionBuilderImpl(Map<S, MutableState<T, S, E, C>> states, TransitionType transitionType, int priority, ExecutionContext executionContext) {
        this.states = states;
        this.transitionType = transitionType;
        this.priority = priority;
        this.executionContext = executionContext;
    }

    @Override
    public void perform(Action<T, S, E, C> action) {
        this.transition.addAction(action);
    }

    @Override
    public void perform(List<? extends Action<T, S, E, C>> actions) {
        this.transition.addActions(actions);
    }

    @Override
    public void evalMvel(String expression) {
        Action action = FSM.newMvelAction(expression, this.executionContext);
        this.transition.addAction(action);
    }

    @Override
    public void callMethod(String methodName) {
        MethodCallActionProxyImpl action = FSM.newMethodCallActionProxy(methodName, this.executionContext);
        this.transition.addAction(action);
    }

    @Override
    public On<T, S, E, C> on(E event) {
        this.transition = this.sourceState.addTransitionOn(event);
        this.transition.setTargetState(this.targetState);
        this.transition.setType(this.transitionType);
        this.transition.setPriority(this.priority);
        return this;
    }

    @Override
    public To<T, S, E, C> to(S stateId) {
        this.targetState = FSM.getState(this.states, stateId);
        return this;
    }

    @Override
    public To<T, S, E, C> toFinal(S stateId) {
        this.targetState = FSM.getState(this.states, stateId);
        if (!this.targetState.isFinalState()) {
            this.targetState.setFinal(true);
        }
        return this;
    }

    @Override
    public From<T, S, E, C> from(S stateId) {
        this.sourceState = FSM.getState(this.states, stateId);
        return this;
    }

    @Override
    public When<T, S, E, C> when(Condition<C> condition) {
        this.transition.setCondition(condition);
        return this;
    }

    @Override
    public When<T, S, E, C> whenMvel(String expression) {
        Condition cond = FSM.newMvelCondition(expression, this.executionContext.getScriptManager());
        this.transition.setCondition(cond);
        return this;
    }

    @Override
    public To<T, S, E, C> within(S stateId) {
        this.targetState = FSM.getState(this.states, stateId);
        this.sourceState = this.targetState;
        return this;
    }
}

