/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.exception.ErrorCodes;
import org.squirrelframework.foundation.exception.SquirrelRuntimeException;

public class ReflectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectUtils.class);

    private ReflectUtils() {
    }

    public static Set<Field> getAllDeclaredFields(Class<?> theClass) {
        HashSet aFields = Sets.newHashSet();
        for (Class<?> aClass = theClass; aClass != null; aClass = aClass.getSuperclass()) {
            aFields.addAll(Sets.newHashSet((Object[])aClass.getDeclaredFields()));
        }
        return aFields;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return ReflectUtils.getField(clazz, fieldName, clazz);
    }

    private static Field getField(Class<?> clazz, String fieldName, Class<?> original) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            if (logger.isTraceEnabled()) {
                logger.trace("found field " + fieldName + " in " + ReflectUtils.getClassNameSafe(clazz));
            }
        }
        catch (SecurityException e) {
            throw new SquirrelRuntimeException(e, ErrorCodes.NOT_ALLOW_ACCESS_FIELD, ReflectUtils.getClassNameSafe(clazz), fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtils.getField(clazz.getSuperclass(), fieldName, original);
            }
            throw new SquirrelRuntimeException(e, ErrorCodes.FIELD_NOT_FOUND, original.getName(), fieldName);
        }
        return field;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        return ReflectUtils.getMethod(clazz, methodName, parameterTypes, clazz);
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Class<?> original) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (logger.isTraceEnabled()) {
                logger.trace("found method " + ReflectUtils.getClassNameSafe(clazz) + "." + methodName + "(" + Arrays.toString(parameterTypes) + ")");
            }
        }
        catch (SecurityException e) {
            throw new SquirrelRuntimeException(e, ErrorCodes.NOT_ALLOW_ACCESS_METHOD, ReflectUtils.getClassNameSafe(clazz), methodName, ReflectUtils.getParameterTypesText(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtils.getMethod(clazz.getSuperclass(), methodName, parameterTypes, original);
            }
            throw new SquirrelRuntimeException(e, ErrorCodes.METHOD_NOT_FOUND, original.getName(), methodName, ReflectUtils.getParameterTypesText(parameterTypes));
        }
        return method;
    }

    private static String getParameterTypesText(Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            return "";
        }
        StringBuilder parameterTypesText = new StringBuilder();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            parameterTypesText.append(parameterType.getName());
            if (i == parameterTypes.length - 1) continue;
            parameterTypesText.append(", ");
        }
        return parameterTypesText.toString();
    }

    public static String logMethod(Method method) {
        StringBuilder builder = new StringBuilder(method.getDeclaringClass().getSimpleName());
        builder.append('.').append(method.getName()).append('(');
        if (method.getParameterTypes() != null) {
            int size = method.getParameterTypes().length;
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(method.getParameterTypes()[i].getSimpleName());
            }
        }
        builder.append(')');
        return builder.toString();
    }

    public static <T extends Annotation> T getAnnotation(Class<?> theClass, Class<T> theAnnotation) {
        T aAnnotation = null;
        if (theClass.isAnnotationPresent(theAnnotation)) {
            aAnnotation = theClass.getAnnotation(theAnnotation);
        } else {
            if (ReflectUtils.shouldInspectClass(theClass.getSuperclass())) {
                aAnnotation = ReflectUtils.getAnnotation(theClass.getSuperclass(), theAnnotation);
            }
            if (aAnnotation == null) {
                Class<?> aInt;
                Class<?>[] arr$ = theClass.getInterfaces();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (aAnnotation = (T)ReflectUtils.getAnnotation(aInt = arr$[i$], theAnnotation)) == null; ++i$) {
                }
            }
        }
        return aAnnotation;
    }

    public static boolean hasAnnotation(Class<?> theClass, Class<? extends Annotation> theAnnotation) {
        return ReflectUtils.getAnnotation(theClass, theAnnotation) != null;
    }

    public static List<Method> getAnnotatedMethods(Class<?> targetClass, Class<? extends Annotation> annotationClass) {
        ArrayList aMethods = Lists.newArrayList();
        for (Method method : targetClass.getMethods()) {
            if (method.getAnnotation(annotationClass) == null) continue;
            aMethods.add(method);
        }
        if (ReflectUtils.shouldInspectClass(targetClass.getSuperclass())) {
            aMethods.addAll(ReflectUtils.getAnnotatedMethods(targetClass.getSuperclass(), annotationClass));
        }
        for (GenericDeclaration genericDeclaration : targetClass.getInterfaces()) {
            aMethods.addAll(ReflectUtils.getAnnotatedMethods(genericDeclaration, annotationClass));
        }
        return aMethods;
    }

    private static boolean shouldInspectClass(Class<?> theClass) {
        return !Object.class.equals(theClass) && theClass != null;
    }

    public static Field[] getAnnotatedFields(Class<?> targetClass, Class<? extends Annotation> annotationClass) {
        ArrayList annotatedFields = Lists.newArrayList();
        Class<?> k = targetClass;
        while (ReflectUtils.shouldInspectClass(k)) {
            for (Field f : k.getFields()) {
                if (f.getAnnotation(annotationClass) == null) continue;
                annotatedFields.add(f);
            }
            k = k.getSuperclass();
        }
        return annotatedFields.toArray(new Field[0]);
    }

    public static boolean isAnnotatedWith(Object obj, Class<? extends Annotation> theAnnotation) {
        if (obj instanceof Class) {
            return ReflectUtils.hasAnnotation((Class)obj, theAnnotation);
        }
        if (obj instanceof Field) {
            return ((Field)obj).getAnnotation(theAnnotation) != null;
        }
        if (obj instanceof Method) {
            return ((Method)obj).getAnnotation(theAnnotation) != null;
        }
        return false;
    }

    public static Method getFirstMethodOfName(Class<?> clazz, String name) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?>[] parameterTypes) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(parameterTypes);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new SquirrelRuntimeException(e, ErrorCodes.CONSTRUCTOR_NOT_FOUND, type.getName(), Arrays.toString(parameterTypes));
        }
    }

    public static <T> T newInstance(String className) {
        return (T)ReflectUtils.newInstance(ReflectUtils.getClass(className), null, null);
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ReflectUtils.newInstance(clazz, null, null);
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        return ReflectUtils.newInstance(null, constructor, null);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object[] args) {
        return ReflectUtils.newInstance(null, constructor, args);
    }

    private static <T> T newInstance(Class<T> clazz, Constructor<T> constructor, Object[] args) {
        if (clazz == null && constructor == null) {
            throw new IllegalArgumentException("can't create new instance without clazz or constructor");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("creating new instance for class '" + ReflectUtils.getClassNameSafe(clazz) + "' with args " + Arrays.toString(args));
        }
        if (constructor == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("getting default constructor");
            }
            constructor = ReflectUtils.getConstructor(clazz, null);
        }
        boolean oldAccessible = constructor.isAccessible();
        try {
            if (!constructor.isAccessible()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("making constructor accessible");
                }
                constructor.setAccessible(true);
            }
            T t = constructor.newInstance(args);
            return t;
        }
        catch (Throwable t) {
            Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : t;
            throw new SquirrelRuntimeException(cause, ErrorCodes.CONSTRUCT_NEW_INSTANCE_ERROR, ReflectUtils.getClassNameSafe(clazz), Arrays.toString(args));
        }
        finally {
            constructor.setAccessible(oldAccessible);
        }
    }

    public static Object getStatic(Field field) {
        return ReflectUtils.get(field, null);
    }

    public static Object get(Field field, Object object) {
        if (field == null) {
            throw new SquirrelRuntimeException(ErrorCodes.FIELD_NULL);
        }
        boolean oldAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object value = field.get(object);
            if (logger.isTraceEnabled()) {
                logger.trace("got value '" + value + "' from field '" + field.getName() + "'");
            }
            Object object2 = value;
            return object2;
        }
        catch (Exception e) {
            throw new SquirrelRuntimeException(e, ErrorCodes.CANNOT_GET_FIELD_VALUE, field.getName());
        }
        finally {
            field.setAccessible(oldAccessible);
        }
    }

    public static void setStatic(Field field, Object value) {
        ReflectUtils.set(field, null, value);
    }

    public static void set(Field field, Object object, Object value) {
        if (field == null) {
            throw new SquirrelRuntimeException(ErrorCodes.FIELD_NULL);
        }
        boolean oldAccessible = field.isAccessible();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("setting field '" + field.getName() + "' to value '" + value + "'");
            }
            if (!oldAccessible) {
                if (logger.isTraceEnabled()) {
                    logger.trace("making field accessible");
                }
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception e) {
            throw new SquirrelRuntimeException(e, ErrorCodes.CANNOT_SET_FIELD_VALUE, field.getName(), value);
        }
        finally {
            field.setAccessible(oldAccessible);
        }
    }

    public static Object invokeStatic(Method method) {
        return ReflectUtils.invoke(method, null, new Object[0]);
    }

    public static Object invokeStatic(Method method, Object[] args) {
        return ReflectUtils.invoke(method, null, args);
    }

    public static Object invoke(Method method, Object target) {
        return ReflectUtils.invoke(method, target, new Object[0]);
    }

    public static Object invoke(Method method, Object target, Object[] args) {
        if (method == null) {
            throw new SquirrelRuntimeException(ErrorCodes.METHOD_NULL);
        }
        boolean oldAccessible = method.isAccessible();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("invoking '" + method.getName() + "' on '" + target + "' with " + Arrays.toString(args));
            }
            if (!method.isAccessible()) {
                logger.trace("making method accessible");
                method.setAccessible(true);
            }
            Object object = method.invoke(target, args);
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new SquirrelRuntimeException(targetException, ErrorCodes.METHOD_INVOKE_ERROR, method, Arrays.toString(args), target, targetException.getCause());
        }
        catch (Exception e) {
            throw new SquirrelRuntimeException(e, ErrorCodes.METHOD_INVOKE_ERROR, method, Arrays.toString(args), target, e.getMessage());
        }
        finally {
            method.setAccessible(oldAccessible);
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) throws IllegalArgumentException {
        ReflectUtils.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, FieldFilter ff) throws IllegalArgumentException {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                if (ff != null && !ff.matches(field)) continue;
                fc.doWith(field);
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) throws IllegalArgumentException {
        ReflectUtils.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, MethodFilter mf) throws IllegalArgumentException {
        Method[] methods = clazz.getDeclaredMethods();
        for (Method method : methods) {
            if (mf != null && !mf.matches(method)) continue;
            mc.doWith(method);
        }
        if (clazz.getSuperclass() != null) {
            ReflectUtils.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectUtils.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Class<?>[] getSuperclasses(Class<?> type) {
        int i = 0;
        for (Class<?> x = type.getSuperclass(); x != null; x = x.getSuperclass()) {
            ++i;
        }
        Class[] result = new Class[i];
        i = 0;
        for (Class<?> x = type.getSuperclass(); x != null; x = x.getSuperclass()) {
            result[i] = x;
            ++i;
        }
        return result;
    }

    public static boolean isUserDefinedMethod(Method method) {
        return method.getDeclaringClass() != Object.class;
    }

    public static boolean isBeanProperty(Method method) {
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        return methodName.startsWith("get") && !methodName.equals("getClass") ? returnType != null && paramTypes.length == 0 : (methodName.startsWith("is") ? returnType != null && paramTypes.length == 0 : methodName.startsWith("set") && paramTypes.length == 1);
    }

    public static String getPackageName(String className) {
        if (className == null || className.length() == 0) {
            throw new SquirrelRuntimeException(ErrorCodes.ILLEGAL_CLASS_NAME);
        }
        int index = className.lastIndexOf(46);
        if (index != -1) {
            return className.substring(0, index);
        }
        return "";
    }

    public static Class<?> getClass(String className) {
        if (className == null || className.length() == 0) {
            throw new SquirrelRuntimeException(ErrorCodes.ILLEGAL_CLASS_NAME);
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SquirrelRuntimeException(e, ErrorCodes.CLASS_NOT_FOUND, className);
        }
    }

    private static String getClassNameSafe(Class<?> maybeNullClazz) {
        if (maybeNullClazz == null) {
            return null;
        }
        return maybeNullClazz.getName();
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface FieldCallback {
        public void doWith(Field var1);
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1);
    }
}

