/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.beancontext;

import java.util.Map;
import org.tinygroup.beancontainer.BeanContainer;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.context.BaseContext;
import org.tinygroup.context.Context;
import org.tinygroup.context.util.ContextFactory;

public class BeanContextImpl
implements Context {
    protected Context context;
    protected BeanContainer<?> beanContainer;

    public BeanContextImpl(Context context) {
        this.context = context;
        this.beanContainer = BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader());
    }

    public BeanContextImpl() {
        this(ContextFactory.getContext());
    }

    public BeanContainer<?> getBeanContainer() {
        return this.beanContainer;
    }

    public void setBeanContainer(BeanContainer<?> beanContainer) {
        this.beanContainer = beanContainer;
    }

    public <T> T put(String name, T object) {
        return (T)this.context.put(name, object);
    }

    public boolean renameKey(String key, String newKey) {
        return this.context.renameKey(key, newKey);
    }

    public <T> T remove(String name) {
        return (T)this.context.remove(name);
    }

    public <T> T get(String name) {
        if (this.context.exist(name)) {
            return (T)this.context.get(name);
        }
        Object t = this.beanContainer.getBean(name);
        this.context.put(name, t);
        return (T)t;
    }

    public void putAll(Map<String, Object> map) {
        this.context.putAll(map);
    }

    public <T> T get(String name, T defaultValue) {
        return (T)this.context.get(name, defaultValue);
    }

    public int size() {
        return this.context.size();
    }

    public boolean exist(String name) {
        return this.context.exist(name);
    }

    public BaseContext contain(String s) {
        return null;
    }

    public void clear() {
        this.context.clear();
    }

    public Map<String, Object> getItemMap() {
        return this.context.getItemMap();
    }

    public Context createSubContext(String contextName) {
        return this.context.createSubContext(contextName);
    }

    public <T> T remove(String contextName, String name) {
        return (T)this.context.remove(contextName, name);
    }

    public <T> T get(String contextName, String name) {
        return (T)this.context.get(contextName, (Object)name);
    }

    public <T> T put(String contextName, String name, T object) {
        return (T)this.context.put(contextName, name, object);
    }

    public Context getParent() {
        return this.context.getParent();
    }

    public void setParent(Context parent) {
        this.context.setParent(parent);
    }

    public Context putSubContext(String contextName, Context subContext) {
        return this.context.putSubContext(contextName, subContext);
    }

    public Context removeSubContext(String contextName) {
        return this.context.removeSubContext(contextName);
    }

    public Context getSubContext(String contextName) {
        return this.context.getSubContext(contextName);
    }

    public void clearSubContext() {
        this.context.clearSubContext();
    }

    public Map<String, Context> getSubContextMap() {
        return this.context.getSubContextMap();
    }

    public <T> T getInSubContext(String contextName, String name) {
        return (T)this.context.getInSubContext(contextName, name);
    }

    public Map<String, Object> getTotalItemMap() {
        return this.context.getTotalItemMap();
    }
}

