/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinytestutil;

import java.io.InputStream;
import java.util.List;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.application.impl.ApplicationDefault;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.FileResolverFactory;
import org.tinygroup.fileresolver.FileResolverUtil;
import org.tinygroup.fileresolver.impl.ConfigurationFileProcessor;
import org.tinygroup.fileresolver.impl.LocalPropertiesFileProcessor;
import org.tinygroup.fileresolver.impl.MergePropertiesFileProcessor;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.remoteconfig.RemoteConfigReadClient;
import org.tinygroup.remoteconfig.utils.RemoteConfigHandler;
import org.tinygroup.springutil.SpringBeanContainer;
import org.tinygroup.springutil.fileresolver.SpringBeansFileProcessor;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

@Deprecated
public abstract class AbstractTestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestUtil.class);
    private static final String TINY_JAR_PATTERN = "org\\.tinygroup\\.(.)*\\.jar";
    private static boolean init = false;
    private static Application application;
    private static String DEFAULT_CONFIG;
    private static RemoteConfigReadClient remoteConfigReadClient;

    public static void setRemoteConfigReadClient(RemoteConfigReadClient remoteConfigReadClient) {
        AbstractTestUtil.remoteConfigReadClient = remoteConfigReadClient;
    }

    public static void setInit(boolean init) {
        AbstractTestUtil.init = init;
    }

    public static void init(String xmlFile, boolean classPathResolve) {
        if (init) {
            return;
        }
        AbstractTestUtil.initDirect(xmlFile, classPathResolve);
    }

    public static void initDirect(String xmlFile, boolean classPathResolve) {
        InputStream inputStream;
        String configXml = xmlFile;
        if (null == configXml || "".equals(configXml)) {
            configXml = DEFAULT_CONFIG;
        }
        if ((inputStream = AbstractTestUtil.class.getClassLoader().getResourceAsStream(configXml)) == null) {
            inputStream = AbstractTestUtil.class.getResourceAsStream(configXml);
        }
        String applicationConfig = "";
        if (inputStream != null) {
            try {
                List processorConfigs;
                XmlNode applicationXml;
                applicationConfig = StreamUtil.readText((InputStream)inputStream, (String)"UTF-8", (boolean)false);
                application = new ApplicationDefault();
                if (applicationConfig != null) {
                    ConfigurationManager c = ConfigurationUtil.getConfigurationManager();
                    applicationXml = (XmlNode)new XmlStringParser().parse(applicationConfig).getRoot();
                    c.setApplicationConfiguration(applicationXml);
                }
                AbstractTestUtil.initSpring(applicationConfig);
                FileResolver fileResolver = (FileResolver)BeanContainerFactory.getBeanContainer((ClassLoader)AbstractTestUtil.class.getClassLoader()).getBean("fileResolver");
                FileResolverUtil.addClassPathPattern((FileResolver)fileResolver);
                fileResolver.addIncludePathPattern(TINY_JAR_PATTERN);
                AbstractTestUtil.loadFileResolverConfig(fileResolver, applicationConfig);
                applicationXml = ConfigurationUtil.getConfigurationManager().getApplicationConfiguration();
                if (applicationXml != null && (processorConfigs = applicationXml.getSubNodesRecursively("application-processor")) != null) {
                    for (XmlNode processorConfig : processorConfigs) {
                        String processorBean = processorConfig.getAttribute("bean");
                        ApplicationProcessor processor = (ApplicationProcessor)BeanContainerFactory.getBeanContainer((ClassLoader)AbstractTestUtil.class.getClassLoader()).getBean(processorBean);
                        application.addApplicationProcessor(processor);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u8f7d\u5165\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}\uff01", (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        application.init();
        application.start();
        init = true;
    }

    public static void stop() {
        if (init && application != null) {
            AbstractTestUtil.setRemoteConfigReadClient(null);
            application.stop();
        }
    }

    private static void initSpring(String applicationConfig) {
        BeanContainerFactory.initBeanContainer((String)SpringBeanContainer.class.getName());
        FileResolver fileResolver = FileResolverFactory.getFileResolver();
        FileResolverUtil.addClassPathPattern((FileResolver)fileResolver);
        fileResolver.addIncludePathPattern(TINY_JAR_PATTERN);
        AbstractTestUtil.loadFileResolverConfig(fileResolver, applicationConfig);
        LocalPropertiesFileProcessor localFileProcessor = new LocalPropertiesFileProcessor(applicationConfig);
        localFileProcessor.start();
        if (remoteConfigReadClient != null) {
            RemoteConfigHandler remoteConfig = new RemoteConfigHandler(applicationConfig, remoteConfigReadClient);
            remoteConfig.start();
        }
        MergePropertiesFileProcessor mergeProcessor = new MergePropertiesFileProcessor();
        mergeProcessor.start();
        fileResolver.addFileProcessor((FileProcessor)new SpringBeansFileProcessor());
        fileResolver.addFileProcessor((FileProcessor)new ConfigurationFileProcessor());
        fileResolver.resolve();
    }

    private static void loadFileResolverConfig(FileResolver fileResolver, String applicationConfig) {
        XmlStringParser parser = new XmlStringParser();
        XmlNode root = (XmlNode)parser.parse(applicationConfig).getRoot();
        PathFilter filter = new PathFilter((Node)root);
        XmlNode appConfig = (XmlNode)filter.findNode("/application/file-resolver-configuration");
        fileResolver.config(appConfig, null);
    }

    static {
        DEFAULT_CONFIG = "application.xml";
    }
}

