/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.uiengine.manager.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.uiengine.config.UIComponent;
import org.tinygroup.uiengine.config.UIComponents;
import org.tinygroup.uiengine.manager.UIComponentManager;

public class UIComponentManagerImpl
implements UIComponentManager {
    static Logger logger = LoggerFactory.getLogger(UIComponentManagerImpl.class);
    List<UIComponent> healthyComponentList = new ArrayList<UIComponent>();
    List<UIComponent> oldHealthyComponentList = new ArrayList<UIComponent>();
    private List<UIComponent> uiComponentList = new ArrayList<UIComponent>();
    private volatile boolean calculating;
    private volatile boolean modified;
    private Map<String, UIComponent> uiMap = new HashMap<String, UIComponent>();
    private UIComponentComparator comparator = new UIComponentComparator();

    @Override
    public List<UIComponent> getUiComponents() {
        return this.uiComponentList;
    }

    @Override
    public List<UIComponent> getHealthUiComponents() {
        return this.calculating ? this.oldHealthyComponentList : this.healthyComponentList;
    }

    @Override
    public void addUIComponents(UIComponents uiComponents) {
        for (UIComponent component : uiComponents.getComponents()) {
            this.addUiComponent(component, uiComponents.getResourcePath());
        }
    }

    private void addUiComponent(UIComponent component, String resourcePath) {
        if (this.uiMap.get(component.getName()) == null) {
            this.uiComponentList.add(component);
            this.uiMap.put(component.getName(), component);
            this.modified = true;
        } else {
            logger.logMessage(LogLevel.ERROR, "\u540d\u79f0{0}\u7684UI\u7ec4\u4ef6\u5305\u5b58\u5728\u91cd\u590d,\u8def\u5f84\u4e3a{1}\u7684\u540c\u540d\u8d44\u6e90\u88ab\u5ffd\u7565!", new Object[]{component.getName(), resourcePath});
        }
    }

    @Override
    public boolean isHealth(String name) {
        String[] dependencies;
        UIComponent component = this.getUIComponent(name);
        if (component == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230UI\u7ec4\u4ef6\u5305\uff1a" + name);
        }
        if (component.isComputed()) {
            if (!this.healthyComponentList.contains(component)) {
                this.healthyComponentList.add(component);
            }
            return component.isHealth();
        }
        if (component.getDependencies() == null || component.getDependencies().trim().length() == 0) {
            component.setComputed(true);
            component.setHealth(true);
            if (!this.healthyComponentList.contains(component)) {
                this.healthyComponentList.add(component);
            }
            return true;
        }
        for (String dependencyName : dependencies = component.getDependencies().split(",")) {
            if (this.isHealth(dependencyName)) continue;
            logger.logMessage(LogLevel.ERROR, "UI\u5305<{}>\u4f9d\u8d56\u7684<{}>UI\u5305\uff0c\u4e0d\u80fd\u88ab\u627e\u5230\uff0c\u56e0\u6b64\u4e0d\u4f1a\u88ab\u52a0\u8f7d\uff01\u4f9d\u8d56\u6b64\u5305\u7684\u5e94\u7528\u53ef\u80fd\u4e0d\u4f1a\u88ab\u987a\u5e8f\u6267\u884c\u3002", new Object[]{name, dependencyName});
            component.setComputed(true);
            component.setHealth(false);
            return false;
        }
        component.setComputed(true);
        component.setHealth(true);
        if (!this.healthyComponentList.contains(component)) {
            this.healthyComponentList.add(component);
        }
        return true;
    }

    @Override
    public UIComponent getUIComponent(String name) {
        return this.uiMap.get(name);
    }

    @Override
    public String[] getComponentJsArray(UIComponent component) {
        String path = component.getJsResource();
        if (path != null && path.trim().length() > 0) {
            String[] paths = path.trim().split(",");
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = paths[i].trim();
            }
            return paths;
        }
        return null;
    }

    @Override
    public String[] getComponentCssArray(UIComponent component) {
        String path = component.getCssResource();
        if (path != null && path.trim().length() > 0) {
            String[] paths = path.trim().split(",");
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = paths[i].trim();
            }
            return paths;
        }
        return null;
    }

    @Override
    public void removeUIComponents(UIComponents uiComponents) {
        this.uiComponentList.removeAll(uiComponents.getComponents());
        for (UIComponent component : uiComponents.getComponents()) {
            this.uiMap.remove(component.getName());
            this.healthyComponentList.remove(component);
            this.modified = true;
        }
    }

    @Override
    public void compute() {
        if (this.modified && !this.calculating) {
            this.realCompute();
        }
    }

    private void realCompute() {
        this.calculating = true;
        this.oldHealthyComponentList = this.healthyComponentList;
        this.healthyComponentList = new ArrayList<UIComponent>();
        try {
            for (UIComponent component : this.uiComponentList) {
                component.setComputed(false);
            }
            Collections.sort(this.uiComponentList, this.comparator);
            for (UIComponent component : this.uiComponentList) {
                this.isHealth(component.getName());
            }
        }
        finally {
            this.calculating = false;
            this.modified = false;
            this.oldHealthyComponentList.clear();
        }
    }

    @Override
    public void reset() {
        this.healthyComponentList.clear();
    }

    class UIComponentComparator
    implements Comparator<UIComponent> {
        UIComponentComparator() {
        }

        @Override
        public int compare(UIComponent o1, UIComponent o2) {
            return this.compareByName(o1, o2);
        }

        private int compareByName(UIComponent o1, UIComponent o2) {
            int v2;
            int v1 = this.getNameProtity(o1.getName());
            if (v1 > (v2 = this.getNameProtity(o2.getName()))) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        private int getNameProtity(String name) {
            return name.hashCode();
        }
    }
}

