/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.webservice.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.webservice.config.ContextParams;
import org.tinygroup.webservice.manager.ContextParamManager;
import org.tinygroup.xstream.XStreamFactory;

public class ContextParamFileProcessor
extends AbstractFileProcessor {
    private static final String CONTEXT_PARAM_EXT_FILENAME = ".contextparam.xml";
    private ContextParamManager contextParamManager;

    public ContextParamManager getContextParamManager() {
        return this.contextParamManager;
    }

    public void setContextParamManager(ContextParamManager contextParamManager) {
        this.contextParamManager = contextParamManager;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"contextParam");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664webservice\u53c2\u6570\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            ContextParams contextParams = (ContextParams)this.caches.get(fileObject.getAbsolutePath());
            if (contextParams != null) {
                this.contextParamManager.removeContextParams(contextParams);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664webservice\u53c2\u6570\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dwebservice\u53c2\u6570\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            ContextParams oldMatchers = (ContextParams)this.caches.get(fileObject.getAbsolutePath());
            if (oldMatchers != null) {
                this.contextParamManager.removeContextParams(oldMatchers);
            }
            InputStream inputStream = fileObject.getInputStream();
            ContextParams matchers = (ContextParams)stream.fromXML(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            this.contextParamManager.addContextParams(matchers);
            this.caches.put(fileObject.getAbsolutePath(), matchers);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dwebservice\u53c2\u6570\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(CONTEXT_PARAM_EXT_FILENAME);
    }
}

