/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.webservice.processor;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.ResourceLoader;
import com.sun.xml.ws.transport.http.servlet.JAXWSRIDeploymentProbeProvider;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import com.sun.xml.ws.transport.http.servlet.WSServletDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.ws.WebServiceException;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.weblayer.listener.TinyServletContext;
import org.tinygroup.webservice.config.ContextParam;
import org.tinygroup.webservice.config.ContextParams;
import org.tinygroup.webservice.config.PastPattern;
import org.tinygroup.webservice.config.SkipPattern;
import org.tinygroup.webservice.manager.ContextParamManager;
import org.tinygroup.webservice.processor.ServletContainer;
import org.tinygroup.webservice.processor.ServletResourceLoader;
import org.tinygroup.webservice.util.WebserviceUtil;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class TG_WSServletContextListener
implements ServletContextAttributeListener,
ServletContextListener {
    private static final String DEFAULT_CONTEXT_PATH_NAME = "default";
    private static final String PAST_TAG = "past-pattern";
    private static final String SKIP_TAG = "skip-pattern";
    private static final String SKIP_ATTRIBUTE = "pattern";
    private static final String PAST_ATTRIBUTE = "pattern";
    private static final String JAXWS_RI_RUNTIME = "/WEB-INF/sun-jaxws.xml";
    private static final String JAXWS_RI_RUNTIME2 = "sun-jaxws.xml";
    private static final Logger logger = LoggerFactory.getLogger((String)"com.sun.xml.ws.server.http");
    private final JAXWSRIDeploymentProbeProvider probe = new JAXWSRIDeploymentProbeProvider();
    private CEPCore core;
    private ContextParamManager contextParamManager;
    private WSServletDelegate delegate;
    private List<ServletAdapter> adapters;
    private Map<String, Pattern> skipPathPatternMap = new HashMap<String, Pattern>();
    private Map<String, Pattern> pastPathPatternMap = new HashMap<String, Pattern>();
    private boolean isInitialized;
    private boolean isDestroyed;

    public CEPCore getCore() {
        return this.core;
    }

    public void setCore(CEPCore core) {
        this.core = core;
    }

    public ContextParamManager getContextParamManager() {
        return this.contextParamManager;
    }

    public void setContextParamManager(ContextParamManager contextParamManager) {
        this.contextParamManager = contextParamManager;
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.isDestroyed) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.destroy();
        }
        if (this.adapters != null) {
            for (ServletAdapter a : this.adapters) {
                try {
                    a.getEndpoint().dispose();
                }
                catch (Throwable e) {
                    logger.logMessage(LogLevel.INFO, e.getMessage(), e);
                }
                this.probe.undeploy(a);
            }
        }
        logger.logMessage(LogLevel.INFO, WsservletMessages.LISTENER_INFO_DESTROY());
        this.isDestroyed = true;
    }

    private List<ServiceInfo> getPublishService(String linsenterConfig) {
        if (linsenterConfig == null || "".equals(linsenterConfig)) {
            return new ArrayList<ServiceInfo>();
        }
        XmlStringParser parser = new XmlStringParser();
        XmlNode xmlNode = (XmlNode)parser.parse((Object)linsenterConfig).getRoot();
        this.addSkipPathPattern(xmlNode);
        this.addSkipPathPattern(this.contextParamManager.getAllSkipPattens());
        this.addPastPathPattern(xmlNode);
        this.addPastPathPattern(this.contextParamManager.getAllPastPatterns());
        List serviceInfos = this.core.getServiceInfos();
        ArrayList<ServiceInfo> publishList = new ArrayList<ServiceInfo>();
        for (ServiceInfo serviceInfo : serviceInfos) {
            String serviceId = serviceInfo.getServiceId();
            if (this.isSkip(serviceId) || !this.isPast(serviceId)) continue;
            publishList.add(serviceInfo);
        }
        return publishList;
    }

    private void addPastPathPattern(List<PastPattern> allPastPatterns) {
        for (PastPattern pastPattern : allPastPatterns) {
            this.addPastPathPattern(pastPattern.getPattern());
        }
    }

    private void addSkipPathPattern(List<SkipPattern> allSkipPattens) {
        for (SkipPattern skipPattern : allSkipPattens) {
            this.addSkipPathPattern(skipPattern.getPattern());
        }
    }

    private void addSkipPathPattern(XmlNode xmlNode) {
        List skipTags = xmlNode.getSubNodes(SKIP_TAG);
        if (skipTags == null) {
            return;
        }
        for (XmlNode tag : skipTags) {
            String pattern = tag.getAttribute("pattern");
            this.addSkipPathPattern(pattern);
        }
    }

    public void addSkipPathPattern(String pattern) {
        this.skipPathPatternMap.put(pattern, Pattern.compile(pattern));
    }

    private void addPastPathPattern(XmlNode xmlNode) {
        List pastTags = xmlNode.getSubNodes(PAST_TAG);
        if (pastTags == null) {
            return;
        }
        for (XmlNode tag : pastTags) {
            String pattern = tag.getAttribute("pattern");
            this.addPastPathPattern(pattern);
        }
    }

    public void addPastPathPattern(String pattern) {
        this.pastPathPatternMap.put(pattern, Pattern.compile(pattern));
    }

    boolean isSkip(String serviceId) {
        for (String patternString : this.skipPathPatternMap.keySet()) {
            Pattern pattern = this.skipPathPatternMap.get(patternString);
            Matcher matcher = pattern.matcher(serviceId);
            if (!matcher.find()) continue;
            logger.logMessage(LogLevel.INFO, "\u670d\u52a1<{}>\u7531\u4e8e\u5339\u914d\u4e86\u5ffd\u7565\u6b63\u5219\u8868\u8fbe\u5f0f<{}>\u800c\u88ab\u5ffd\u7565\u3002", new Object[]{serviceId, patternString});
            return true;
        }
        return false;
    }

    boolean isPast(String serviceId) {
        for (String patternString : this.pastPathPatternMap.keySet()) {
            Pattern pattern = this.pastPathPatternMap.get(patternString);
            Matcher matcher = pattern.matcher(serviceId);
            if (!matcher.find()) continue;
            return true;
        }
        logger.logMessage(LogLevel.INFO, "\u670d\u52a1<{}>\u7531\u4e8e\u4e0d\u5339\u914d\u6240\u6709\u7684Past\u6b63\u5219\u8868\u8fbe\u5f0f\u800c\u88ab\u5ffd\u7565\u3002", new Object[]{serviceId});
        return false;
    }

    public void contextInitialized(ServletContextEvent event) {
        if (this.isInitialized) {
            return;
        }
        logger.logMessage(LogLevel.INFO, WsservletMessages.LISTENER_INFO_INITIALIZE());
        TinyServletContext context = (TinyServletContext)ServletContextHolder.getServletContext();
        this.initParam(this.contextParamManager.getAllContextParams(), context);
        String linsenterConfig = context.getInitParameter("tiny-listener-config");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String contextPath = StringUtil.substringAfter((String)context.getContextPath(), (String)"/");
        String targetNamespace = context.getInitParameter("target-namespace");
        if (StringUtil.isBlank((String)targetNamespace)) {
            targetNamespace = StringUtil.isBlank((String)contextPath) ? "org.tinygroup.webservice.server.impl.default" : "org.tinygroup.webservice.server.impl." + contextPath.toLowerCase();
        }
        List<ServiceInfo> serviceInfos = this.getPublishService(linsenterConfig);
        for (ServiceInfo serviceInfo : serviceInfos) {
            try {
                logger.logMessage(LogLevel.INFO, "\u5f00\u59cb\u53d1\u5e03\u670d\u52a1" + serviceInfo.getServiceId());
                this.createService(targetNamespace, serviceInfo, classLoader, (ServletContext)context);
                logger.logMessage(LogLevel.INFO, "\u53d1\u5e03\u670d\u52a1" + serviceInfo.getServiceId() + "\u6210\u529f");
            }
            catch (Throwable e) {
                logger.errorMessage(WsservletMessages.LISTENER_PARSING_FAILED((Object)e), e, new Object[0]);
            }
        }
        if (this.adapters == null) {
            this.adapters = new ArrayList<ServletAdapter>();
        }
        this.delegate = this.createDelegate(this.adapters, (ServletContext)context);
        context.setAttribute("com.sun.xml.ws.server.http.servletDelegate", (Object)this.delegate);
        if (this.adapters != null) {
            for (ServletAdapter adapter : this.adapters) {
                this.probe.deploy(adapter);
            }
        }
        this.isInitialized = true;
    }

    private void initParam(List<ContextParams> allContextParams, TinyServletContext servletContext) {
        for (ContextParams contextParams : allContextParams) {
            for (ContextParam contextParam : contextParams.getContextParams()) {
                servletContext.setInitParameter(contextParam.getName(), contextParam.getValue());
            }
        }
    }

    private void createService(String packageName, ServiceInfo serviceInfo, ClassLoader classLoader, ServletContext context) throws IOException {
        WebserviceUtil.genWSDL(serviceInfo, packageName);
        DeploymentDescriptorParser parser = new DeploymentDescriptorParser(classLoader, (ResourceLoader)new ServletResourceLoader(context), this.createContainer(context), (DeploymentDescriptorParser.AdapterFactory)new ServletAdapterList());
        URL sunJaxWsXml = context.getResource(JAXWS_RI_RUNTIME);
        if (sunJaxWsXml == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            sunJaxWsXml = loader.getResource(JAXWS_RI_RUNTIME2);
        }
        if (sunJaxWsXml == null) {
            throw new WebServiceException(WsservletMessages.NO_SUNJAXWS_XML((Object)"/WEB-INF/sun-jaxws.xml and sun-jaxws.xml"));
        }
        InputStream is = WebserviceUtil.getXmlInputStream(serviceInfo, packageName);
        if (this.adapters == null) {
            this.adapters = parser.parse(sunJaxWsXml.toExternalForm(), is);
        } else {
            this.adapters.addAll(parser.parse(sunJaxWsXml.toExternalForm(), is));
        }
    }

    @NotNull
    protected Container createContainer(ServletContext context) {
        return new ServletContainer(context);
    }

    @NotNull
    protected WSServletDelegate createDelegate(List<ServletAdapter> adapters, ServletContext context) {
        return new WSServletDelegate(adapters, context);
    }
}

