/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.webservice.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.event.Parameter;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.loader.LoaderManager;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.xmlparser.node.XmlNode;

public class WebserviceUtil {
    public static final String PACKAGE_NAME = "org.tinygroup.webservice.server.impl";
    private static Logger logger = LoggerFactory.getLogger(WebserviceUtil.class);
    private static final Map<String, String> method2ServiceId = new HashMap<String, String>();

    public static void genWSDL(ServiceInfo serviceInfo, String packageName) {
        WebserviceUtil.loadServiceClass(serviceInfo, packageName);
    }

    public static String getServiceIdByMethodName(String methodName) {
        return method2ServiceId.get(methodName);
    }

    private static Class loadServiceClass(ServiceInfo serviceInfo, String packageName) {
        String serviceInfoId = serviceInfo.getServiceId();
        String methodName = StringUtil.replace((String)serviceInfoId, (String)".", (String)"");
        method2ServiceId.put(methodName, serviceInfoId);
        String className = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        className = packageName + "." + className;
        ClassPool pool = ClassPool.getDefault();
        pool.importPackage(packageName);
        CtClass cc = pool.makeClass(className);
        cc.stopPruning(true);
        ClassFile cf = cc.getClassFile();
        AnnotationsAttribute attribute = new AnnotationsAttribute(cf.getConstPool(), "RuntimeVisibleAnnotations");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetNamespace", packageName);
        WebserviceUtil.addAnnotation(cf, "javax.jws.WebService", attribute, params);
        WebserviceUtil.addTinyWebserviceAnnotation(cf, "org.tinygroup.webservice.annotation.TinyWebService", attribute);
        cf.addAttribute((AttributeInfo)attribute);
        cf.setVersionToJava5();
        try {
            CtMethod cm = WebserviceUtil.getCtMethod(cc, serviceInfo);
            cc.addMethod(cm);
        }
        catch (CannotCompileException e1) {
            logger.errorMessage(e1.getMessage(), (Throwable)e1, new Object[0]);
        }
        catch (Exception e1) {
            logger.errorMessage(e1.getMessage(), (Throwable)e1, new Object[0]);
        }
        try {
            cc.writeFile();
            cc.defrost();
            return cc.toClass();
        }
        catch (NotFoundException e) {
            logger.errorMessage("class:{className} \u6587\u4ef6\u672a\u627e\u5230", (Throwable)e, new Object[]{className});
        }
        catch (CannotCompileException e) {
            logger.errorMessage(e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            logger.errorMessage(e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    public static InputStream getXmlInputStream(ServiceInfo serviceInfo, String packageName) {
        XmlNode root = new XmlNode("endpoints");
        root.setAttribute("xmlns", "http://java.sun.com/xml/ns/jax-ws/ri/runtime");
        root.setAttribute("version", "2.0");
        String serviceId = serviceInfo.getServiceId();
        String urlPattern = "/services/" + serviceId;
        String methodName = StringUtil.replace((String)serviceId, (String)".", (String)"");
        String className = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        className = packageName + "." + className;
        List endpoints = root.getSubNodes(serviceId);
        if (endpoints != null) {
            for (XmlNode xmlNode : endpoints) {
                root.removeNode((Node)xmlNode);
            }
        } else {
            XmlNode node = new XmlNode("endpoint");
            node.setAttribute("name", serviceId);
            node.setAttribute("implementation", className);
            node.setAttribute("url-pattern", urlPattern);
            root.addNode((Node)node);
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + root;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("utf-8"));
            return is;
        }
        catch (UnsupportedEncodingException e) {
            logger.errorMessage(e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private static void addAnnotation(ClassFile cf, String name, AnnotationsAttribute attribute, Map<String, String> params) {
        ConstPool cp = cf.getConstPool();
        Annotation annotation = new Annotation(name, cp);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            annotation.addMemberValue(entry.getKey(), (MemberValue)new StringMemberValue(entry.getValue(), cp));
        }
        attribute.addAnnotation(annotation);
    }

    private static void addTinyWebserviceAnnotation(ClassFile cf, String name, AnnotationsAttribute attribute) {
        ConstPool cp = cf.getConstPool();
        Annotation annotation = new Annotation(name, cp);
        attribute.addAnnotation(annotation);
    }

    private static CtMethod getCtMethod(CtClass cc, ServiceInfo serviceInfo) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        Parameter result;
        String resultName;
        List parameters = serviceInfo.getParameters();
        CtClass[] params = new CtClass[parameters.size()];
        Parameter parameter = null;
        for (int i = 0; i < parameters.size(); ++i) {
            CtClass param;
            parameter = (Parameter)parameters.get(i);
            params[i] = param = WebserviceUtil.getCtMethodParam(parameter);
        }
        String methodName = StringUtil.replace((String)serviceInfo.getServiceId(), (String)".", (String)"");
        CtClass returnType = WebserviceUtil.getCtClass(WebserviceUtil.getResultType(serviceInfo.getResults()));
        CtMethod cm = new CtMethod(returnType, methodName, params, cc);
        cm.setModifiers(1);
        String body = WebserviceUtil.getMethodBody(serviceInfo.getResults());
        if (body != null) {
            cm.setBody(body.toString());
        } else {
            cm.setBody("return;");
        }
        List results = serviceInfo.getResults();
        if (results != null && results.size() > 0 && (resultName = (result = (Parameter)results.get(0)).getName().trim()).length() > 0) {
            ClassFile cf = cc.getClassFile();
            ConstPool cp = cf.getConstPool();
            MethodInfo minfo = cm.getMethodInfo();
            AnnotationsAttribute attr = new AnnotationsAttribute(cp, "RuntimeVisibleAnnotations");
            Annotation webResult = new Annotation("javax.jws.WebResult", cp);
            webResult.addMemberValue("name", (MemberValue)new StringMemberValue(resultName, cp));
            attr.addAnnotation(webResult);
            minfo.addAttribute((AttributeInfo)attr);
        }
        return cm;
    }

    private static CtClass getCtClass(Class<?> type) throws NotFoundException {
        try {
            CtClass ctClass = ClassPool.getDefault().get(type.getName());
            return ctClass;
        }
        catch (NotFoundException e) {
            ClassClassPath classPath = new ClassClassPath(type);
            ClassPool.getDefault().insertClassPath((ClassPath)classPath);
            return ClassPool.getDefault().get(type.getName());
        }
    }

    private static CtClass getCtMethodParam(Parameter parameter) throws ClassNotFoundException, NotFoundException {
        Class<?> type = WebserviceUtil.getJavassistParamType(parameter);
        return WebserviceUtil.getCtClass(type);
    }

    private static Class<?> getJavassistParamType(Parameter parameter) throws ClassNotFoundException {
        if (parameter == null) {
            return null;
        }
        if (parameter.getCollectionType() != null && parameter.getCollectionType().trim().length() > 0) {
            return LoaderManager.getClass((String)parameter.getCollectionType());
        }
        String type = parameter.getType();
        if (parameter.isArray()) {
            return WebserviceUtil.getJavassistParamArray(type);
        }
        if ("char".equals(type)) {
            return Character.TYPE;
        }
        if ("byte".equals(type)) {
            return Byte.TYPE;
        }
        if ("short".equals(type)) {
            return Short.TYPE;
        }
        if ("int".equals(type)) {
            return Integer.TYPE;
        }
        if ("long".equals(type)) {
            return Long.TYPE;
        }
        if ("float".equals(type)) {
            return Float.TYPE;
        }
        if ("double".equals(type)) {
            return Double.TYPE;
        }
        if ("boolean".equals(type)) {
            return Boolean.TYPE;
        }
        return LoaderManager.getClass((String)type);
    }

    private static Class<?> getJavassistParamArray(String type) throws ClassNotFoundException {
        if ("char".equals(type)) {
            return char[].class;
        }
        if ("byte".equals(type)) {
            return byte[].class;
        }
        if ("short".equals(type)) {
            return short[].class;
        }
        if ("int".equals(type)) {
            return int[].class;
        }
        if ("long".equals(type)) {
            return long[].class;
        }
        if ("float".equals(type)) {
            return float[].class;
        }
        if ("double".equals(type)) {
            return double[].class;
        }
        if ("boolean".equals(type)) {
            return boolean[].class;
        }
        return Array.newInstance(LoaderManager.getClass((String)type), 1).getClass();
    }

    private static Class<?> getResultType(List<Parameter> results) throws ClassNotFoundException {
        if (results == null || results.size() == 0) {
            return Void.TYPE;
        }
        return WebserviceUtil.getResultType(results.get(0));
    }

    private static Class<?> getResultType(Parameter parameter) throws ClassNotFoundException {
        if (parameter == null) {
            return Void.TYPE;
        }
        if (parameter.getCollectionType() != null && parameter.getCollectionType().trim().length() > 0) {
            return LoaderManager.getClass((String)parameter.getCollectionType());
        }
        String type = parameter.getType();
        if (type == null || type.trim().length() == 0 || "void".equals(type)) {
            return Void.TYPE;
        }
        if (parameter.isArray()) {
            return WebserviceUtil.getJavassistParamArray(type);
        }
        return LoaderManager.getClass((String)type);
    }

    private static String getMethodBody(Parameter returnType) {
        if (returnType == null) {
            return null;
        }
        if (returnType.isArray()) {
            return "return null;";
        }
        if (returnType.getCollectionType() != null && returnType.getCollectionType().trim().length() > 0) {
            return "return null;";
        }
        String type = returnType.getType();
        if (type == null || type.trim().length() == 0 || "void".equals(type)) {
            return null;
        }
        if ("char".equals(type)) {
            return "return ' ';";
        }
        if ("byte".equals(type)) {
            return "return 0;";
        }
        if ("short".equals(type)) {
            return "return 0;";
        }
        if ("int".equals(type)) {
            return "return 0;";
        }
        if ("long".equals(type)) {
            return "return 0L;";
        }
        if ("float".equals(type)) {
            return "return 0;";
        }
        if ("double".equals(type)) {
            return "return 0.0;";
        }
        if ("boolean".equals(type)) {
            return "return true;";
        }
        return "return null;";
    }

    private static String getMethodBody(List<Parameter> returns) {
        if (returns == null || returns.size() == 0) {
            return null;
        }
        return WebserviceUtil.getMethodBody(returns.get(0));
    }
}

