/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser.node;

import org.tinygroup.parser.Node;
import org.tinygroup.parser.NodeType;
import org.tinygroup.parser.node.NodeImpl;
import org.tinygroup.xmlparser.XmlNodeType;

public class XmlNode
extends NodeImpl<XmlNode, XmlNodeType> {
    public XmlNode(XmlNodeType nodeType) {
        super((NodeType)nodeType);
    }

    public XmlNode(String nodeName) {
        super(nodeName, (NodeType)XmlNodeType.ELEMENT);
    }

    public XmlNode(XmlNodeType nodeType, String nodeName) {
        super((NodeType)nodeType, nodeName);
    }

    public XmlNode(String nodeName, XmlNodeType nodeType) {
        super((NodeType)nodeType, nodeName);
    }

    public XmlNode addContent(String content) {
        XmlNode node = new XmlNode(XmlNodeType.TEXT);
        node.setContent(content);
        this.addNode((Node)node);
        return this;
    }

    protected String encode(String string) {
        String str = string;
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("'", "&apos;");
        return str;
    }

    protected String decode(String string) {
        String str = string;
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&apos;", "'");
        return str;
    }

    public String getPureText() {
        StringBuffer sb = new StringBuffer();
        this.getPureText(this, sb);
        return sb.toString().trim();
    }

    void getPureText(XmlNode node, StringBuffer sb) {
        if (node.getNodeType() == XmlNodeType.CDATA || node.getNodeType() == XmlNodeType.TEXT) {
            String content = node.getContent();
            if (content != null) {
                sb.append(content).append(" ");
            }
        } else if (((XmlNodeType)node.getNodeType()).isHasHeader() && node.getSubNodes() != null) {
            for (XmlNode n : node.getSubNodes()) {
                this.getPureText(n, sb);
            }
        }
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

