/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.parser.Node;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.XmlNodeType;
import org.tinygroup.xmlparser.document.XmlDocumentImpl;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlParser;

public class XmlStringParser
extends XmlParser<String> {
    public static final String HEAD_END_PATTERN = "HeadEndPattern";
    private static final String TAIL_END_PATTERN = "TailEndPattern";
    private static Pattern endTagName = Pattern.compile("(\\w|[\u4e00-\u9fa5]|[.]|[:]|[-])+\\s*>");
    private static Pattern startTagName = Pattern.compile("(\\w|[\u4e00-\u9fa5]|[-]|[:]|[.])+");
    private static Pattern attribute = Pattern.compile("(\\b(\\w|[\u4e00-\u9fa5]|[/]|[:]|[.]|[-])+\\s*=\\s*\"[^\"]*\")|(\\b(\\w|[\u4e00-\u9fa5]|[/]|[.]|[:]|[-])+\\s*=\\s*'[^']*')|(\\b(\\w|[\u4e00-\u9fa5]|[/]|[.]|[-])+\\s*=\\s*(\\w|[\u4e00-\u9fa5]|[.]|[-])+)");
    private static Map<String, Pattern> patternTable = new HashMap<String, Pattern>();
    private int start = 0;

    private String parseNode(String xmlSource, XmlNode pnode) {
        Pattern pattern = Pattern.compile(XmlStringParser.getHeadStartPattern());
        Matcher matcher = pattern.matcher(xmlSource);
        matcher.region(this.start, xmlSource.length());
        block0: while (matcher.find()) {
            String headStart;
            if (this.start < matcher.start()) {
                String str = xmlSource.substring(this.start, matcher.start());
                if (str.trim().length() > 0) {
                    XmlNode node = new XmlNode(XmlNodeType.TEXT);
                    node.setContent(str);
                    pnode.addNode((Node)node);
                }
                this.start = matcher.start();
            }
            if ((headStart = xmlSource.substring(matcher.start(), matcher.end())).equals("/>")) {
                this.start = matcher.end();
                return null;
            }
            if (headStart.equals("</")) {
                Matcher m = endTagName.matcher(xmlSource);
                m.region(this.start, xmlSource.length());
                if (m.find()) {
                    this.start = m.end();
                    String r = xmlSource.substring(m.start(), m.end() - 1).trim();
                    if (r.length() == 0) {
                        return null;
                    }
                    if (r.equals(pnode.getNodeName())) {
                        return null;
                    }
                    return r;
                }
            }
            for (XmlNodeType nodetype : XmlNodeType.values()) {
                Matcher m;
                Pattern p;
                Matcher m2;
                if (nodetype.getHead() == null || nodetype.getHead().getStart() == null || !nodetype.getHead().getStart().equals(headStart)) continue;
                XmlNode node = new XmlNode(nodetype);
                pnode.addNode((Node)node);
                if (nodetype == XmlNodeType.ELEMENT) {
                    m2 = startTagName.matcher(xmlSource);
                    m2.region(this.start, xmlSource.length());
                    if (m2.find()) {
                        node.setNodeName(xmlSource.substring(m2.start(), m2.end()));
                        this.start = m2.end();
                    }
                }
                if (nodetype.isHasHeader()) {
                    m2 = attribute.matcher(xmlSource);
                    m2.region(this.start, xmlSource.indexOf(62, matcher.end()));
                    this.parseHeader(xmlSource, node, m2);
                }
                if (nodetype.getHead().getEnd() != null) {
                    p = patternTable.get((Object)((Object)nodetype) + HEAD_END_PATTERN);
                    if (p == null) {
                        p = Pattern.compile(XmlStringParser.getHeadEndPattern(nodetype));
                        patternTable.put((Object)((Object)nodetype) + HEAD_END_PATTERN, p);
                    }
                    m = p.matcher(xmlSource);
                    m.region(this.start, xmlSource.length());
                    if (m.find()) {
                        char c = xmlSource.charAt(m.start() - 1);
                        this.start = m.end();
                        if (c != '/') {
                            if (nodetype.isHasBody()) {
                                String r = this.parseNode(xmlSource, node);
                                if (r != null) {
                                    if (r.endsWith(pnode.getNodeName())) {
                                        return null;
                                    }
                                    return r;
                                }
                                matcher.region(this.start, xmlSource.length());
                                continue block0;
                            }
                        } else {
                            matcher.region(this.start, xmlSource.length());
                            continue block0;
                        }
                    }
                }
                if (nodetype.getTail() == null || nodetype.getTail().getEnd() == null) continue;
                p = patternTable.get((Object)((Object)nodetype) + TAIL_END_PATTERN);
                if (p == null) {
                    p = Pattern.compile(XmlStringParser.getTailEndPattern(nodetype));
                    patternTable.put((Object)((Object)nodetype) + TAIL_END_PATTERN, p);
                }
                m = p.matcher(xmlSource);
                m.region(matcher.end(), xmlSource.length());
                if (!m.find()) continue;
                node.setContent(xmlSource.substring(matcher.end(), m.start()));
                this.start = m.end();
                matcher.region(this.start, xmlSource.length());
                continue block0;
            }
        }
        return null;
    }

    private void parseHeader(String xmlSource, XmlNode node, Matcher m) {
        while (m.find()) {
            String str = xmlSource.substring(m.start(), m.end());
            String k = str.substring(0, str.indexOf(61)).trim();
            String v = str.substring(str.indexOf(61) + 1).trim();
            if (v.startsWith("\"")) {
                v = v.substring(1, v.length() - 1);
            } else if (v.startsWith("'")) {
                v = v.substring(1, v.length() - 1);
            }
            node.setAttribute(k, v);
            this.start = m.end();
        }
    }

    public XmlDocument parse(String xmlSource) {
        XmlDocumentImpl document = new XmlDocumentImpl();
        Pattern pattern = Pattern.compile(XmlStringParser.getHeadStartPattern());
        Matcher matcher = pattern.matcher(xmlSource);
        block0: while (matcher.find()) {
            this.start = matcher.end();
            String headStart = matcher.group();
            for (XmlNodeType nt : XmlNodeType.values()) {
                Matcher m;
                Pattern p;
                Matcher m2;
                if (nt.getHead() == null || nt.getHead().getStart() == null || !nt.getHead().getStart().equals(headStart)) continue;
                XmlNode node = new XmlNode(nt);
                if (nt == XmlNodeType.ELEMENT) {
                    document.setRoot((Node)node);
                } else if (nt == XmlNodeType.COMMENT) {
                    document.addComment(node);
                } else if (nt == XmlNodeType.DOCTYPE) {
                    document.addDoctype(node);
                } else if (nt == XmlNodeType.XML_DECLARATION) {
                    document.setXmlDeclaration(node);
                } else if (nt == XmlNodeType.PROCESSING_INSTRUCTION) {
                    document.addProcessingInstruction(node);
                }
                if (nt == XmlNodeType.ELEMENT) {
                    m2 = startTagName.matcher(xmlSource);
                    m2.region(this.start, xmlSource.length());
                    if (m2.find()) {
                        node.setNodeName(xmlSource.substring(m2.start(), m2.end()));
                        this.start = m2.end();
                    }
                }
                if (nt.isHasHeader()) {
                    m2 = attribute.matcher(xmlSource);
                    m2.region(this.start, xmlSource.indexOf(62, matcher.end()));
                    this.parseHeader(xmlSource, node, m2);
                }
                if (nt.getHead().getEnd() != null) {
                    p = patternTable.get((Object)((Object)nt) + HEAD_END_PATTERN);
                    if (p == null) {
                        p = Pattern.compile(XmlStringParser.getHeadEndPattern(nt));
                        patternTable.put((Object)((Object)nt) + HEAD_END_PATTERN, p);
                    }
                    m = p.matcher(xmlSource);
                    m.region(matcher.end(), xmlSource.length());
                    if (m.find()) {
                        this.start = m.end();
                        if (nt.isHasBody()) {
                            this.parseNode(xmlSource, node);
                            matcher.region(this.start, xmlSource.length());
                            continue block0;
                        }
                    }
                }
                if (nt.getTail() == null || nt.getTail().getEnd() == null) continue;
                p = patternTable.get((Object)((Object)nt) + TAIL_END_PATTERN);
                if (p == null) {
                    p = Pattern.compile(XmlStringParser.getTailEndPattern(nt));
                    patternTable.put((Object)((Object)nt) + TAIL_END_PATTERN, p);
                }
                m = p.matcher(xmlSource);
                m.region(this.start, xmlSource.length());
                if (!m.find()) continue;
                node.setContent(xmlSource.substring(matcher.end(), m.start()));
                this.start = m.end();
                matcher.region(this.start, xmlSource.length());
                continue block0;
            }
        }
        return document;
    }
}

