/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.statistics.DataSet;
import org.uncommons.watchmaker.framework.CandidateFactory;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.EvolutionEngine;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;
import org.uncommons.watchmaker.framework.FitnessEvaluator;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.SelectionStrategy;
import org.uncommons.watchmaker.framework.TerminationCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvolutionEngine<T>
implements EvolutionEngine<T> {
    private final List<EvolutionObserver<? super T>> observers = new LinkedList<EvolutionObserver<? super T>>();
    private final Random rng;
    private final CandidateFactory<T> candidateFactory;
    private final EvolutionaryOperator<T> evolutionScheme;
    private final FitnessEvaluator<? super T> fitnessEvaluator;
    private final SelectionStrategy<? super T> selectionStrategy;
    private long startTime;
    private int currentGenerationIndex;
    private List<TerminationCondition> satisfiedTerminationConditions;

    protected AbstractEvolutionEngine(CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, FitnessEvaluator<? super T> fitnessEvaluator, SelectionStrategy<? super T> selectionStrategy, Random rng) {
        this.candidateFactory = candidateFactory;
        this.evolutionScheme = evolutionScheme;
        this.fitnessEvaluator = fitnessEvaluator;
        this.selectionStrategy = selectionStrategy;
        this.rng = rng;
    }

    protected final FitnessEvaluator<? super T> getFitnessEvaluator() {
        return this.fitnessEvaluator;
    }

    @Override
    public T evolve(int populationSize, int eliteCount, TerminationCondition ... conditions) {
        return this.evolve(populationSize, eliteCount, Collections.emptySet(), conditions);
    }

    @Override
    public T evolve(int populationSize, int eliteCount, Collection<T> seedCandidates, TerminationCondition ... conditions) {
        List<EvaluatedCandidate<T>> evaluatedPopulation = this.evolvePopulation(populationSize, eliteCount, seedCandidates, conditions);
        ArrayList fittest = new ArrayList(evaluatedPopulation.size());
        double bestFitness = evaluatedPopulation.get(0).getFitness();
        for (EvaluatedCandidate<T> candidate : evaluatedPopulation) {
            if (!(this.fitnessEvaluator.isNatural() && candidate.getFitness() >= bestFitness) && (this.fitnessEvaluator.isNatural() || !(candidate.getFitness() <= bestFitness))) break;
            fittest.add(candidate);
        }
        return (T)this.selectionStrategy.select(fittest, this.fitnessEvaluator.isNatural(), 1, this.rng).get(0);
    }

    @Override
    public List<EvaluatedCandidate<T>> evolvePopulation(int populationSize, int eliteCount, TerminationCondition ... conditions) {
        return this.evolvePopulation(populationSize, eliteCount, Collections.emptySet(), conditions);
    }

    @Override
    public List<EvaluatedCandidate<T>> evolvePopulation(int populationSize, int eliteCount, Collection<T> seedCandidates, TerminationCondition ... conditions) {
        if (eliteCount < 0 || eliteCount >= populationSize) {
            throw new IllegalArgumentException("Elite count must be non-negative and less than population size.");
        }
        if (conditions.length == 0) {
            throw new IllegalArgumentException("At least one TerminationCondition must be specified.");
        }
        this.satisfiedTerminationConditions = null;
        this.currentGenerationIndex = 0;
        this.startTime = System.currentTimeMillis();
        List<T> population = this.candidateFactory.generateInitialPopulation(populationSize, seedCandidates, this.rng);
        List<EvaluatedCandidate<T>> evaluatedPopulation = this.evaluatePopulation(population);
        this.sortEvaluatedPopulation(evaluatedPopulation);
        PopulationData<T> data = this.getPopulationData(evaluatedPopulation, eliteCount);
        this.notifyPopulationChange(data);
        List<TerminationCondition> satisfiedConditions = this.shouldContinue(data, conditions);
        while (satisfiedConditions == null) {
            ++this.currentGenerationIndex;
            population = this.createNextGeneration(evaluatedPopulation, eliteCount);
            evaluatedPopulation = this.evaluatePopulation(population);
            this.sortEvaluatedPopulation(evaluatedPopulation);
            data = this.getPopulationData(evaluatedPopulation, eliteCount);
            this.notifyPopulationChange(data);
            satisfiedConditions = this.shouldContinue(data, conditions);
        }
        this.satisfiedTerminationConditions = satisfiedConditions;
        return evaluatedPopulation;
    }

    private List<TerminationCondition> shouldContinue(PopulationData<T> data, TerminationCondition ... conditions) {
        if (Thread.currentThread().isInterrupted()) {
            return Collections.emptyList();
        }
        LinkedList<TerminationCondition> satisfiedConditions = new LinkedList<TerminationCondition>();
        for (TerminationCondition condition : conditions) {
            if (!condition.shouldTerminate(data)) continue;
            satisfiedConditions.add(condition);
        }
        return satisfiedConditions.isEmpty() ? null : satisfiedConditions;
    }

    @Override
    public List<TerminationCondition> getSatisfiedTerminationConditions() {
        if (this.satisfiedTerminationConditions == null) {
            throw new IllegalStateException("EvolutionEngine has not terminated.");
        }
        return Collections.unmodifiableList(this.satisfiedTerminationConditions);
    }

    protected abstract List<EvaluatedCandidate<T>> evaluatePopulation(List<T> var1);

    private void sortEvaluatedPopulation(List<EvaluatedCandidate<T>> evaluatedPopulation) {
        if (this.getFitnessEvaluator().isNatural()) {
            Collections.sort(evaluatedPopulation, Collections.reverseOrder());
        } else {
            Collections.sort(evaluatedPopulation);
        }
    }

    private List<T> createNextGeneration(List<EvaluatedCandidate<T>> evaluatedPopulation, int eliteCount) {
        List<Object> population = new ArrayList(evaluatedPopulation.size());
        ArrayList<T> elite = new ArrayList<T>(eliteCount);
        Iterator<EvaluatedCandidate<T>> iterator = evaluatedPopulation.iterator();
        while (elite.size() < eliteCount) {
            elite.add(iterator.next().getCandidate());
        }
        population.addAll(this.selectionStrategy.select(evaluatedPopulation, this.fitnessEvaluator.isNatural(), evaluatedPopulation.size() - eliteCount, this.rng));
        population = this.evolutionScheme.apply(population, this.rng);
        population.addAll(elite);
        return population;
    }

    @Override
    public void addEvolutionObserver(EvolutionObserver<? super T> observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeEvolutionObserver(EvolutionObserver<? super T> observer) {
        this.observers.remove(observer);
    }

    private void notifyPopulationChange(PopulationData<T> data) {
        for (EvolutionObserver<T> observer : this.observers) {
            observer.populationUpdate(data);
        }
    }

    private PopulationData<T> getPopulationData(List<EvaluatedCandidate<T>> evaluatedPopulation, int eliteCount) {
        DataSet stats = new DataSet(evaluatedPopulation.size());
        for (EvaluatedCandidate<T> candidate : evaluatedPopulation) {
            stats.addValue(candidate.getFitness());
        }
        return new PopulationData<T>(evaluatedPopulation.get(0).getCandidate(), evaluatedPopulation.get(0).getFitness(), stats.getArithmeticMean(), stats.getStandardDeviation(), this.getFitnessEvaluator().isNatural(), stats.getSize(), eliteCount, this.currentGenerationIndex, System.currentTimeMillis() - this.startTime);
    }
}

