/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestar.CodeStarAsyncClient;
import software.amazon.awssdk.services.codestar.CodeStarAsyncClientBuilder;
import software.amazon.awssdk.services.codestar.CodeStarServiceClientConfiguration;
import software.amazon.awssdk.services.codestar.DefaultCodeStarAsyncClient;
import software.amazon.awssdk.services.codestar.DefaultCodeStarBaseClientBuilder;
import software.amazon.awssdk.services.codestar.endpoints.CodeStarEndpointProvider;

@SdkInternalApi
final class DefaultCodeStarAsyncClientBuilder
extends DefaultCodeStarBaseClientBuilder<CodeStarAsyncClientBuilder, CodeStarAsyncClient>
implements CodeStarAsyncClientBuilder {
    DefaultCodeStarAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeStarAsyncClientBuilder endpointProvider(CodeStarEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeStarAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeStarAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodeStarServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeStarAsyncClient client = new DefaultCodeStarAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeStarServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeStarServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

