/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.fis.DefaultFisBaseClientBuilder;
import software.amazon.awssdk.services.fis.DefaultFisClient;
import software.amazon.awssdk.services.fis.FisClient;
import software.amazon.awssdk.services.fis.FisClientBuilder;
import software.amazon.awssdk.services.fis.FisServiceClientConfiguration;
import software.amazon.awssdk.services.fis.endpoints.FisEndpointProvider;

@SdkInternalApi
final class DefaultFisClientBuilder
extends DefaultFisBaseClientBuilder<FisClientBuilder, FisClient>
implements FisClientBuilder {
    DefaultFisClientBuilder() {
    }

    @Override
    public DefaultFisClientBuilder endpointProvider(FisEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FisClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultFisClientBuilder.validateClientOptions(clientConfiguration);
        FisServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultFisClient client = new DefaultFisClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private FisServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return FisServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

