/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.FirewallMetadata;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse;

public class ListFirewallsPublisher
implements SdkPublisher<ListFirewallsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListFirewallsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFirewallsPublisher(NetworkFirewallAsyncClient client, ListFirewallsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFirewallsPublisher(NetworkFirewallAsyncClient client, ListFirewallsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFirewallsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFirewallsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FirewallMetadata> firewalls() {
        Function<ListFirewallsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewalls() != null) {
                return response.firewalls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFirewallsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFirewallsResponseFetcher
    implements AsyncPageFetcher<ListFirewallsResponse> {
        private ListFirewallsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFirewallsResponse> nextPage(ListFirewallsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallsPublisher.this.client.listFirewalls(ListFirewallsPublisher.this.firstRequest);
            }
            return ListFirewallsPublisher.this.client.listFirewalls((ListFirewallsRequest)((Object)ListFirewallsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

