/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.internal.UserAgentUtils;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse;
import software.amazon.awssdk.services.swf.model.WorkflowTypeInfo;

public class ListWorkflowTypesIterable
implements SdkIterable<ListWorkflowTypesResponse> {
    private final SwfClient client;
    private final ListWorkflowTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowTypesIterable(SwfClient client, ListWorkflowTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowTypesResponseFetcher();
    }

    public Iterator<ListWorkflowTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowTypeInfo> typeInfos() {
        Function<ListWorkflowTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.typeInfos() != null) {
                return response.typeInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowTypesResponseFetcher
    implements SyncPageFetcher<ListWorkflowTypesResponse> {
        private ListWorkflowTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListWorkflowTypesResponse nextPage(ListWorkflowTypesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowTypesIterable.this.client.listWorkflowTypes(ListWorkflowTypesIterable.this.firstRequest);
            }
            return ListWorkflowTypesIterable.this.client.listWorkflowTypes((ListWorkflowTypesRequest)((Object)ListWorkflowTypesIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

