/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.filters;

import java.io.File;
import ws.schild.jave.Color;
import ws.schild.jave.Utils;
import ws.schild.jave.VideoFilter;

public class VideoDrawtext
extends VideoFilter {
    private String watermarkText = null;
    private int posX = -1;
    private int posY = -1;
    private String fontName = "Arial";
    private File fontFile = null;
    private float fontSize = 10.0f;
    private Color fontColor = null;
    private int lineSpacing = 0;
    private Color shadowColor = null;
    private int shadowX = 2;
    private int shadowY = 2;
    private int boxBorderWidth = 0;
    private Color boxColor = null;
    private int borderWidth = 0;
    private Color borderColor = null;
    private String addArgument = null;

    public VideoDrawtext(String watermarkText, Color fontColor) throws IllegalArgumentException {
        this.watermarkText = watermarkText;
        this.fontColor = fontColor;
    }

    public VideoDrawtext(String watermarkText, int posX, int posY, String fontName, File fontFile, float fontSize, Color fontColor) throws IllegalArgumentException {
        this.watermarkText = watermarkText;
        this.posX = posX;
        this.posY = posY;
        this.fontName = fontName;
        this.fontFile = fontFile;
        this.fontSize = fontSize;
        this.fontColor = fontColor;
    }

    public VideoDrawtext setShadow(Color shadowColor, int shadowX, int shadowY) {
        this.shadowColor = shadowColor;
        this.shadowX = shadowX;
        this.shadowY = shadowY;
        return this;
    }

    public String getWatermarkText() {
        return this.watermarkText;
    }

    public VideoDrawtext setWatermarkText(String watermarkText) {
        this.watermarkText = watermarkText;
        return this;
    }

    public int getPosX() {
        return this.posX;
    }

    public VideoDrawtext setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public VideoDrawtext setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public String getFontName() {
        return this.fontName;
    }

    public VideoDrawtext setFontName(String fontName) {
        this.fontName = fontName;
        return this;
    }

    public File getFontFile() {
        return this.fontFile;
    }

    public VideoDrawtext setFontFile(File fontFile) {
        this.fontFile = fontFile;
        return this;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public VideoDrawtext setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public VideoDrawtext setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public VideoDrawtext setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
        return this;
    }

    public int getShadowX() {
        return this.shadowX;
    }

    public VideoDrawtext setShadowX(int shadowX) {
        this.shadowX = shadowX;
        return this;
    }

    public int getShadowY() {
        return this.shadowY;
    }

    public VideoDrawtext setShadowY(int shadowY) {
        this.shadowY = shadowY;
        return this;
    }

    public VideoDrawtext setBox(int borderWidth, Color color) {
        this.setBoxBorderWidth(borderWidth);
        this.setBoxColor(color);
        return this;
    }

    public int getBoxBorderWidth() {
        return this.boxBorderWidth;
    }

    public VideoDrawtext setBoxBorderWidth(int boxBorderWidth) {
        this.boxBorderWidth = boxBorderWidth;
        return this;
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public VideoDrawtext setBoxColor(Color boxColor) {
        this.boxColor = boxColor;
        return this;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public VideoDrawtext setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public VideoDrawtext setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public VideoDrawtext setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        return this;
    }

    public String getAddArgument() {
        return this.addArgument;
    }

    public VideoDrawtext setAddArgument(String addArgument) {
        this.addArgument = addArgument;
        return this;
    }

    @Override
    public String getExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append("drawtext=text='");
        sb.append(Utils.escapeArgument(this.watermarkText));
        if (this.posX != -1 && this.posY != -1) {
            sb.append("':x=");
            sb.append(Integer.toString(this.posX));
            sb.append("':y=");
            sb.append(Integer.toString(this.posY));
        }
        if (this.fontName != null) {
            sb.append(":font=");
            sb.append(this.fontName);
        } else if (this.fontFile != null) {
            sb.append(":fontfile=");
            sb.append(this.fontFile.getAbsoluteFile());
        } else {
            throw new IllegalArgumentException("Need either fontName or fontFile");
        }
        sb.append(":fontsize=");
        sb.append(Float.toString(this.fontSize));
        sb.append(":fontcolor=");
        sb.append(this.fontColor.getFfmpegColor());
        if (this.lineSpacing != 0) {
            sb.append(":line_spacing:").append(Integer.toString(this.lineSpacing));
        }
        if (this.shadowColor != null) {
            sb.append(":shadowcolor");
            sb.append(this.shadowColor.getFfmpegColor());
            sb.append(":shadowx=");
            sb.append(Integer.toString(this.shadowX));
            sb.append(":shadowy=");
            sb.append(Integer.toString(this.shadowY));
        }
        if (this.boxColor != null) {
            sb.append(":box=1:boxcolor");
            sb.append(this.boxColor.getFfmpegColor());
            sb.append(":boxborderw=");
            sb.append(Integer.toString(this.boxBorderWidth));
        }
        if (this.borderWidth != 0) {
            sb.append(":bordercolor");
            sb.append(this.borderColor.getFfmpegColor());
            sb.append(":borderw=");
            sb.append(Integer.toString(this.boxBorderWidth));
        }
        if (this.addArgument != null) {
            sb.append(":");
            sb.append(this.addArgument);
        }
        return sb.toString();
    }
}

