/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.facade;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.adapi.model.dto.MediaAdPositionDto;
import com.bxm.adapi.model.dto.MediaAdPositionEditDto;
import com.bxm.adapi.model.ro.MediaAdPositionRo;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;

/**
 * @ClassName MediaAdPositionService.java
 * @Description 功能描述： 媒体广告位相关接口
 * @author leon 2018年4月2日 上午11:58:51
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "adapi")
public interface MediaAdPositionService {

    /**
     * @Description 方法描述： 新增
     * @author leon 2017年10月23日 下午4:17:41
     * @CopyRight 杭州微财网络科技有限公司
     * @param MediaAdPositionEditDto
     * @return
     * @throws Exception
     * @throws ValidateException
     */
    @RequestMapping(value = "/mediaAdPosition/add", method = RequestMethod.POST)
    public ResultModel<Boolean> add(@RequestBody MediaAdPositionEditDto MediaAdPositionEditDto) throws ValidateException,
                                                                                                Exception;

    /**
     * @Description 方法描述： 批量逻辑删除
     * @author leon 2017年10月23日 下午4:17:47
     * @CopyRight 杭州微财网络科技有限公司
     * @param ids
     * @return
     * @throws Exception
     * @throws ValidateException
     */
    @RequestMapping(value = "/mediaAdPosition/delete", method = RequestMethod.DELETE)
    public ResultModel<Boolean> delete(@RequestParam(value = "ids", required = true) List<Long> ids) throws ValidateException,
                                                                                                     Exception;

    /**
     * @Description 方法描述： 修改
     * @author leon 2017年10月23日 下午4:17:54
     * @CopyRight 杭州微财网络科技有限公司
     * @param MediaAdPositionEditDto
     * @return
     * @throws Exception
     * @throws ValidateException
     */
    @RequestMapping(value = "/mediaAdPosition/update", method = RequestMethod.PUT)
    public ResultModel<Boolean> update(@RequestBody MediaAdPositionEditDto MediaAdPositionEditDto) throws ValidateException,
                                                                                                   Exception;

    /**
     * @Description 方法描述： 根据条件查询列表
     * @author leon 2017年10月23日 下午4:18:02
     * @CopyRight 杭州微财网络科技有限公司
     * @param MediaAdPositionDto
     * @return
     */
    @RequestMapping(value = "/mediaAdPosition/getList", method = RequestMethod.POST)
    public ResultModel<PageInfo<MediaAdPositionRo>> getList(@RequestBody MediaAdPositionDto MediaAdPositionDto);

}
