/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.integration.xunfei;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtils {
    private static final OkHttpClient mOkHttpClient = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public static String get(String url) throws IOException {
        Request request = new Request.Builder().url(url).get().build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String get(String url, Map<String, String> headers) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).get();
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String get(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        StringBuffer paramSb = new StringBuffer();
        if (params != null) {
            for (Map.Entry<String, Object> e : params.entrySet()) {
                if (e.getValue() == null) continue;
                paramSb.append(URLEncoder.encode(e.getKey(), "UTF-8"));
                paramSb.append("=");
                paramSb.append(URLEncoder.encode(e.getValue().toString(), "UTF-8"));
                paramSb.append("&");
            }
        }
        if (paramSb.length() > 0) {
            String paramStr = paramSb.toString();
            paramStr = paramStr.substring(0, paramStr.length() - 1);
            url = url + "?" + paramStr;
        }
        Request.Builder builder = new Request.Builder().url(url).get();
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String post(String url, String params, Map<String, String> headers) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)params);
        Request.Builder builder = new Request.Builder().url(url).post(body);
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String post(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        FormBody.Builder build = new FormBody.Builder();
        for (String key : params.keySet()) {
            if (params.get(key) == null) continue;
            build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
        }
        FormBody body = build.build();
        Request.Builder builder = new Request.Builder().url(url).post((RequestBody)body);
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String put(String url, String params, Map<String, String> headers) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)params);
        Request.Builder builder = new Request.Builder().url(url).put(body);
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String put(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        FormBody.Builder build = new FormBody.Builder();
        for (String key : params.keySet()) {
            if (params.get(key) == null) continue;
            build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
        }
        FormBody body = build.build();
        Request.Builder builder = new Request.Builder().url(url).put((RequestBody)body);
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String delete(String url, Map<String, String> headers) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).delete();
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String patch(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        FormBody.Builder build = new FormBody.Builder();
        for (String key : params.keySet()) {
            if (params.get(key) == null) continue;
            build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
        }
        FormBody body = build.build();
        Request.Builder builder = new Request.Builder().url(url).put((RequestBody)body);
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String patch(String url, String params, Map<String, String> headers) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)params);
        Request.Builder builder = new Request.Builder().url(url).patch(body);
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    public static String head(String url, Map<String, String> headers) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).head();
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }
}

