/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CustomJsonDateDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = jp.getText();
        if (date != null && date.length() == "yyyy-MM-dd".length()) {
            format = new SimpleDateFormat("yyyy-MM-dd");
        }
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

