/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.api.controller;

import com.bxm.adsprod.api.resolver.IpAddress;
import com.bxm.adsprod.facade.ticket.CheckCouponRequest;
import com.bxm.adsprod.facade.ticket.NoValidTicketException;
import com.bxm.adsprod.facade.ticket.TicketCouponRequest;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.sc.domain.StaticResourceMapping;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ticket"})
public class AdticketController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdticketController.class);
    @Autowired
    private TicketService ticketService;

    @StaticResourceMapping
    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public ResponseModel get(ViewRequest viewRequest) {
        String url = "http://i.tandehao.com/activities/?appKey=fbca14bb5bb74d5a9b5fa165ad78a15a&appType=app&appEntrance=1&business=money&i=__IMEI__&f=__IDFA__";
        try {
            url = this.ticketService.get(viewRequest.getTicketId()).getUrl();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return ResponseModelFactory.SUCCESS((Object)url);
    }

    @RequestMapping(value={"/getCoupon"}, method={RequestMethod.GET})
    public ResultModel getCoupon(@IpAddress TicketCouponRequest ticketCouponRequest) throws NoValidTicketException {
        try {
            if (StringUtils.isBlank((CharSequence)ticketCouponRequest.getUid())) {
                ticketCouponRequest.setUid(ticketCouponRequest.getImei());
            }
            List ticketCoupons = this.ticketService.getCoupon(ticketCouponRequest);
            ResultModel resultModel = ResultModelFactory.SUCCESS(List.class);
            resultModel.setReturnValue((Object)ticketCoupons);
            return resultModel;
        }
        catch (Exception e) {
            LOGGER.error("getCoupon error", (Throwable)e);
            return ResultModelFactory.SUCCESS();
        }
    }

    @RequestMapping(value={"/checkCoupon"}, method={RequestMethod.POST})
    public ResultModel checkCoupon(@RequestBody CheckCouponRequest checkCouponRequest) throws NoValidTicketException {
        try {
            List checkCoupons = this.ticketService.checkCoupon(checkCouponRequest);
            ResultModel resultModel = ResultModelFactory.SUCCESS(List.class);
            resultModel.setReturnValue((Object)checkCoupons);
            return resultModel;
        }
        catch (Exception e) {
            LOGGER.error("checkCoupon error", (Throwable)e);
            return ResultModelFactory.SUCCESS();
        }
    }
}

