/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.api.controller;

import com.bxm.adscounter.facade.Mt;
import com.bxm.adscounter.facade.model.NoStatisticsException;
import com.bxm.adscounter.facade.model.Response;
import com.bxm.adscounter.facade.model.TicketCountMsgDto;
import com.bxm.adscounter.facade.model.TicketCounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.integration.adscounter.AdscounterServiceIntegration;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@RestController
@RequestMapping(value={"/limit"})
public class LimitController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LimitController.class);
    private final ThreadPoolExecutor dotThreadPool = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("dot"));
    @Resource(name="redisFetcher")
    private Fetcher fetcher;
    @Autowired
    private TicketService ticketService;
    @Autowired
    private AdscounterServiceIntegration asi;

    @RequestMapping(value={"/fetch"})
    public String[] fetch(HttpServletRequest request) {
        String ticketId2;
        Map enableds = this.fetcher.hfetchall(new TargetFactory().keyGenerator(TicketKeyGenerator.Threshold.getLimitPriceEnabled()).cls(String.class).build());
        if (MapUtils.isEmpty((Map)enableds)) {
            return new String[0];
        }
        ArrayList tickets = Lists.newArrayList();
        Set ticketIds = enableds.keySet();
        for (String ticketId2 : ticketIds) {
            Ticket ticket = this.ticketService.get(new BigInteger(ticketId2));
            if (null == ticket || !ticket.isAvailableForStatus()) continue;
            tickets.add(ticket);
        }
        if (CollectionUtils.isEmpty((Collection)tickets)) {
            return new String[0];
        }
        Ticket ticket = (Ticket)tickets.get(RandomUtils.nextInt((int)tickets.size()));
        ticketId2 = String.valueOf(ticket.getId());
        String values = (String)enableds.get(ticketId2);
        if (StringUtils.isBlank((String)values)) {
            return new String[0];
        }
        String[] item = StringUtils.split((String)values, (String)"-");
        double avgClickPrice = NumberUtils.toDouble((String)item[0]);
        double clickRatio = NumberUtils.toDouble((String)item[1]);
        if (avgClickPrice == 0.0 || clickRatio == 0.0) {
            return new String[0];
        }
        BigDecimal times = new BigDecimal(1).divide(new BigDecimal(clickRatio), 2, 4);
        int currentTimes = times.intValue();
        double currentRemainder = times.subtract(new BigDecimal(currentTimes)).doubleValue();
        int remainderTimes = this.getRemainderTimes(ticketId2, currentRemainder);
        int totalTimes = currentTimes + remainderTimes;
        for (int i = 0; i < totalTimes; ++i) {
            this.dotThreadPool.submit(new DotSimulation(this.asi, this.create(request, ticket), Mt._5.getOriginal()));
            this.dotThreadPool.submit(new DotSimulation(this.asi, this.create(request, ticket), Mt._6.getOriginal()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] avgClickPrice={}, clickRatio={}. originDotTime: {}, totalTimes: {}, remainderTimes: {}, dotRatio: {}", new Object[]{ticketId2, avgClickPrice, clickRatio, times, totalTimes, currentRemainder, new BigDecimal(1).divide(new BigDecimal(totalTimes), 3, 4).doubleValue()});
        }
        Future<Response> future = this.dotThreadPool.submit(new DotSimulation(this.asi, this.create(request, ticket), Mt._7.getOriginal()));
        String bxmId = null;
        try {
            Response response = future.get();
            if (null != response) {
                bxmId = response.getOrderId();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("get: ", (Throwable)e);
        }
        String url = ticket.getUrl();
        if (StringUtils.isNotBlank((String)bxmId)) {
            url = url + (StringUtils.contains((String)url, (String)"?") ? "&bxm_id=" + bxmId : "?bxm_id=" + bxmId);
        }
        return new String[]{url};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRemainderTimes(String ticketId, double currentRemainder) {
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = jedisPool.getResource();
        try {
            int times = 0;
            double remainder = jedis.hincrByFloat(TicketKeyGenerator.Threshold.getLimitPriceRemainder().generateKey(), ticketId, currentRemainder);
            while (remainder >= 1.0) {
                remainder = jedis.hincrByFloat(TicketKeyGenerator.Threshold.getLimitPriceRemainder().generateKey(), ticketId, -1.0);
                if (!(remainder >= 0.0)) continue;
                ++times;
            }
            int n = times;
            return n;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    private TicketCountMsgDto create(HttpServletRequest request, Ticket ticket) {
        TicketCountMsgDto dto = new TicketCountMsgDto();
        dto.setAppkey("fbca14bb5bb74d5a9b5fa165ad78a15a");
        dto.setBusiness("money-20");
        dto.setReferrer(request.getHeader("Referer"));
        dto.setUserAgent(request.getHeader("User-Agent"));
        dto.setActivityid(Long.valueOf(12651L));
        dto.setAppos(Integer.valueOf(1));
        dto.setUa("0");
        dto.setPreid(Long.valueOf(ticket.getId().longValue()));
        dto.setIpAddress(IpHelper.getIpFromHeader((HttpServletRequest)request));
        dto.setAwardtype(Integer.valueOf(2));
        dto.setAssetsId("-1");
        dto.setUid("_____DEFAULT_UID_FOR_LIMIT_PRICE");
        return dto;
    }

    static class DotSimulation
    implements Callable<Response> {
        private static final Logger LOGGER = LoggerFactory.getLogger(DotSimulation.class);
        private final AdscounterServiceIntegration asi;
        private final TicketCountMsgDto dto;
        private final int modelType;

        public DotSimulation(AdscounterServiceIntegration asi, TicketCountMsgDto dto, int modelType) {
            this.asi = asi;
            this.dto = dto;
            this.modelType = modelType;
        }

        @Override
        public Response call() {
            try {
                TicketCounterRequest tcr = new TicketCounterRequest();
                this.dto.setModeltype(Integer.valueOf(this.modelType));
                tcr.setTicketCountMsgDto(this.dto);
                return this.asi.saveTicketCountMsg2(tcr);
            }
            catch (NoStatisticsException e) {
                LOGGER.error("saveTicketCountMsg2: ", (Throwable)e);
                return null;
            }
        }
    }
}

