package com.bxm.adsprod.facade.commons;

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.List;

/**
 * <h3>用于消息队列的消息体</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
public class MessageBody implements Serializable {

    private static final long serialVersionUID = -7574842720165619981L;

    /**
     * 请求参数
     */
    private Object request;

    private Class<?> requestClass;

    /**
     * 返回对象
     */
    private Object returning;

    private Class<?> returningClass;

    public MessageBody(Object request, Object returning) {
        this(request, null != request ? request.getClass() : null,
                returning, null != returning ? returning.getClass() : null);
    }

    public MessageBody(Object request, Class<?> requestClass, Object returning, Class<?> returningClass) {
        this.request = request;
        this.requestClass = requestClass;
        this.returning = returning;
        this.returningClass = returningClass;
    }

    public Object getRequest() {
        return request;
    }

    public void setRequest(Object request) {
        this.request = request;
    }

    public Class<?> getRequestClass() {
        return requestClass;
    }

    public void setRequestClass(Class<?> requestClass) {
        this.requestClass = requestClass;
    }

    public Object getReturning() {
        return returning;
    }

    public void setReturning(Object returning) {
        this.returning = returning;
    }

    public Class<?> getReturningClass() {
        return returningClass;
    }

    public void setReturningClass(Class<?> returningClass) {
        this.returningClass = returningClass;
    }
}
