package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * <h3>Click request</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/26
 */
public class ClickRequest implements Serializable {

    private static final long serialVersionUID = -269873396903039069L;
    @ValidateNotNull
    private String uid;
    @ValidateNotNull
    private BigInteger ticketId;

    public ClickRequest() {
    }

    public static ClickRequest of(String uid, BigInteger ticketId) {
        return new ClickRequest(uid, ticketId);
    }

    public ClickRequest(String uid, BigInteger ticketId) {
        this.uid = uid;
        this.ticketId = ticketId;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }
}
