package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.warcar.utils.Constants;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.RandomUtils;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

/**
 * @author allen
 * @date 2017-12-04
 */
public class Ticket implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    public static final byte SETTLE_TYPE_CPC = 1;
    public static final byte SETTLE_TYPE_CPA = 2;

    /**
     * 常规券
     */
    public static final byte TYPE_NORMAL = 1;
    /**
     * 备用券
     */
    public static final byte TYPE_STANDBY = 2;

    /**
     * 开启
     */
    public static final byte STATUS_OPEN = 1;
    /**
     * 暂停
     */
    public static final byte STATUS_PAUSE = 2;
    /**
     * 停止
     */
    public static final byte STATUS_CLOSE = 3;
    /**
     * 已删除
     */
    public static final byte STATUS_DELETED = 99;

    public static final int PAUSE_REASON_NONE = 0;
    /**
     * 日预算不足
     */
    public static final int PAUSE_REASON_OUT_OF_DAILYBUDGET = 1;
    /**
     * 余额不足
     */
    public static final int PAUSE_REASON_BALANCE_NOT_ENOUGHT = 2;
    /**
     * 未到投放日期
     */
    public static final int PAUSE_REASON_NO_START = 3;
    /**
     * 已结束
     */
    public static final int PAUSE_REASON_ENDED = 4;


    private BigInteger id;
    private String name;
    private BigInteger advertiser;
    private Byte settleType;
    private Integer price;
    private Byte type;
    private Integer budgetDaily;
    private String domainCode;
    private Double standaloneCost;
    private String url;
    private Date validStartDate;
    private Date validEndDate;
    /**
     * 是否支持微信
     * @see com.bxm.warcar.utils.Constants#YES
     * @see com.bxm.warcar.utils.Constants#NO
     */
    private Byte isSupportWechat;
    /**
     * 用户评分及格分数线
     */
    private Integer userGradePassScore;
    private Byte status;
    private Integer pauseReason;

    private List<TicketOs> oss;
    private List<Tag> tags;
    private List<TicketOnoff> onoffs;
    private List<TicketAssets> assets;

    public boolean isCPC() {
        return null != settleType && settleType.byteValue() == SETTLE_TYPE_CPC;
    }

    public boolean isNormalType() {
        return null != type && type.byteValue() == TYPE_NORMAL;
    }

    /**
     * 该广告券的状态是否为打开(可用)
     * @return
     */
    public boolean isAvailableForStatus() {
        return null != status && status.byteValue() == STATUS_OPEN;
    }

    /**
     * 该广告券是否有可用的素材
     * @return
     */
    public boolean isAvailableForAssets() {
        if (CollectionUtils.isEmpty(assets)) {
            return false;
        }
        for (TicketAssets asset : assets) {
            if (asset.isAvailable()) {
                return true;
            }
        }
        return false;
    }

    public TicketAssets randomAssets() {
        // 筛选掉关闭的素材
        List<TicketAssets> rst = Lists.newArrayList();
        for (TicketAssets asset : assets) {
            if (asset.isAvailable()) {
                rst.add(asset);
            }
        }

        return null == rst ? null : rst.get(RandomUtils.nextInt(rst.size()));
    }

    public boolean isSupportedOs(int os) {
        if (CollectionUtils.isEmpty(oss)) {
            return false;
        }
        for (TicketOs ticketOs : oss) {
            if (ticketOs.getSupportOs().byteValue() == os) {
                return true;
            }
        }
        return false;
    }

    public boolean isSupportedWechat() {
        return null != isSupportWechat && isSupportWechat.byteValue() == Constants.YES;
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigInteger getAdvertiser() {
        return advertiser;
    }

    public void setAdvertiser(BigInteger advertiser) {
        this.advertiser = advertiser;
    }

    public Byte getSettleType() {
        return settleType;
    }

    public void setSettleType(Byte settleType) {
        this.settleType = settleType;
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Integer getBudgetDaily() {
        return budgetDaily;
    }

    public void setBudgetDaily(Integer budgetDaily) {
        this.budgetDaily = budgetDaily;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Double getStandaloneCost() {
        return standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public Byte getIsSupportWechat() {
        return isSupportWechat;
    }

    public void setIsSupportWechat(Byte isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Integer getUserGradePassScore() {
        return userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public List<TicketOnoff> getOnoffs() {
        return onoffs;
    }

    public void setOnoffs(List<TicketOnoff> onoffs) {
        this.onoffs = onoffs;
    }

    public List<TicketOs> getOss() {
        return oss;
    }

    public void setOss(List<TicketOs> oss) {
        this.oss = oss;
    }

    public List<TicketAssets> getAssets() {
        return assets;
    }

    public void setAssets(List<TicketAssets> assets) {
        this.assets = assets;
    }

    public Integer getPauseReason() {
        return pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
