package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.utils.Constants;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * @author allen
 * @date 2017-12-05
 */
public class TicketAssets implements Serializable {
    private static final long serialVersionUID = 4368329874159718574L;

    private BigInteger id;
    private String name;
    private String image;
    private String intro;
    private String buttonTxt;
    /**
     * 状态
     * @see com.bxm.warcar.utils.Constants#YES
     * @see com.bxm.warcar.utils.Constants#NO
     */
    private Byte status;

    public boolean isAvailable() {
        return null != status && status.byteValue() == Constants.YES;
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public String getButtonTxt() {
        return buttonTxt;
    }

    public void setButtonTxt(String buttonTxt) {
        this.buttonTxt = buttonTxt;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

}
