package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.commons.CachePushableFields;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang.math.NumberUtils;

import java.math.BigInteger;
import java.util.Map;

/**
 * <h3>广告券相关KEY创建者</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/12
 */
public final class TicketKeyGenerator {

    public static class Advertiser {

        private Advertiser() {}

        public static KeyGenerator getBalance() {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "ADVERTISER", "BALANCE");
                }
            };
        }
    }

    public static class Media {
        private Media() {}

        public static KeyGenerator getPositions() {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "POSITION", "ALL");
                }
            };
        }
    }

    public static class Statistics {

        private Statistics() {}

        public static KeyGenerator getBudgetOfDaily() {
            return getBudgetOfDaily(DateHelper.format("yyyyMMdd"));
        }

        public static KeyGenerator getBudgetOfDaily(String date) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "COUNTER", "DAILY_BUDGET", date);
                }
            };
        }

        public static KeyGenerator getClickOfDaily() {
            return getClickOfDaily(DateHelper.format("yyyyMMdd"));
        }

        public static KeyGenerator getClickOfDaily(String date) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "COUNTER", "CLICK",
                            date);
                }
            };
        }

        public static KeyGenerator getViewOfDaily() {
            return getViewOfDaily(DateHelper.format("yyyyMMdd"));
        }

        public static KeyGenerator getViewOfDaily(String date) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "COUNTER", "VIEW",
                            date);
                }
            };
        }

        public static KeyGenerator getBudgetOfHourly() {
            return getBudgetOfHourly(NumberUtils.toInt(DateHelper.format("H"), -1));
        }

        public static KeyGenerator getBudgetOfHourly(int hour) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "COUNTER", "HOURLY_BUDGET",
                            DateHelper.format("yyyyMMdd"),
                            hour);
                }
            };
        }

        public static KeyGenerator getViewOfHourly() {
            return getViewOfHourly(NumberUtils.toInt(DateHelper.format("H"), -1));
        }

        public static KeyGenerator getViewOfHourly(int hour) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "COUNTER", "HOURLY_VIEW",
                            DateHelper.format("yyyyMMdd"),
                            hour);
                }
            };
        }

        public static KeyGenerator getClickOfDaily(BigInteger ticketId) {
            return getClickOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getClickOfDaily(String date, BigInteger ticketId) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "COUNTER", "UDAILY_CLICK",
                            date,
                            ticketId);
                }
            };
        }

        public static KeyGenerator getViewOfDaily(BigInteger ticketId) {
            return getViewOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getViewOfDaily(String date, BigInteger ticketId) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "COUNTER", "UDAILY_VIEW",
                            date,
                            ticketId);
                }
            };
        }

        public static KeyGenerator getClickOfWeekly(BigInteger ticketId) {
            return getClickOfWeekly(DateHelper.format("yyyyw"), ticketId);
        }

        public static KeyGenerator getClickOfWeekly(String dateweek, BigInteger ticketId) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "COUNTER", "UWEEKLY_CLICK",
                            dateweek,
                            ticketId);
                }
            };
        }

        public static KeyGenerator getViewOfWeekly(BigInteger ticketId) {
            return getViewOfWeekly(DateHelper.format("yyyyw"), ticketId);
        }

        public static KeyGenerator getViewOfWeekly(String dateweek, BigInteger ticketId) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "COUNTER", "UWEEKLY_VIEW",
                            dateweek,
                            ticketId);
                }
            };
        }
    }

    public static class Weight {

        public static KeyGenerator getWeight(BigInteger ticketId, String positionId) {
            return new KeyGenerator() {
                @Override
                public String generateKey() {
                    return KeyBuilder.build("AD", "WEIGHT", "TICKET", ticketId);
                }
            };
        }
    }

    public static KeyGenerator getAllTickets() {
        return new KeyGenerator() {
            @Override
            public String generateKey() {
                return KeyBuilder.build("AD", "TICKET", "ALL");
            }
        };
    }

    public static KeyGenerator getTicketPrice(Map<String, Object> parameters) {
        return new KeyGenerator() {
            @Override
            public String generateKey() {
                return KeyBuilder.build("AD", "WEIGHT", "TICKET_PRICE",
                        parameters.get(CachePushableFields.TICKET_ID),
                        parameters.get(CachePushableFields.POSITION_ID));
            }
        };
    }

    public static KeyGenerator getTicketPriceOfTodayFirst(Map<String, Object> parameters) {
        return new KeyGenerator() {
            @Override
            public String generateKey() {
                return KeyBuilder.build("AD", "WEIGHT", "TICKET_PRICE_TF",
                        parameters.get(CachePushableFields.TICKET_ID),
                        parameters.get(CachePushableFields.POSITION_ID));
            }
        };
    }
    public static KeyGenerator getTicketPriceFloatPercent(Map<String, Object> parameters) {
        return new KeyGenerator() {
            @Override
            public String generateKey() {
                return KeyBuilder.build("AD", "WEIGHT", "TICKET_PRICE_FP",
                        parameters.get(CachePushableFields.TICKET_ID),
                        parameters.get(CachePushableFields.POSITION_ID));
            }
        };
    }

    public static KeyGenerator getTicketMif(Map<String, Object> parameters) {
        return new KeyGenerator() {
            @Override
            public String generateKey() {
                return KeyBuilder.build("AD", "WEIGHT", "TICKET_MIF",
                        parameters.get(CachePushableFields.TICKET_ID),
                        parameters.get(CachePushableFields.POSITION_ID));
            }
        };
    }

    public static KeyGenerator getTicketProfitForCpa(String date) {
        return new KeyGenerator() {
            @Override
            public String generateKey() {
                return KeyBuilder.build("AD", "WEIGHT", "TICKET_PROFIT_FOR_CPA", date);
            }
        };
    }
}
