package com.bxm.adsprod.facade.ticket;

import java.math.BigInteger;
import java.util.List;

/**
 * 广告券服务
 *
 * @author allen
 * @date 2017-12-05
 */
public interface TicketService {

    /**
     * 获取广告券
     *
     * @param ticketRequest
     * @return
     * @throws NoValidTicketException
     */
    Ticket view(TicketRequest ticketRequest) throws NoValidTicketException;

    /**
     * 点击广告券
     *
     * @param clickRequest
     * @return
     * @throws IllegalTicketException
     */
    Ticket click(ClickRequest clickRequest) throws IllegalTicketException;

    /**
     * 返回所有的广告券，包括有效、无效，启用、禁用。
     * @return
     */
    List<Ticket> getAllTickets();

    /**
     * 返回广告券信息
     * @param ticketId
     * @return
     */
    Ticket get(BigInteger ticketId);
}
