package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <h3>有权重的广告券</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
public class TicketWithWeight implements Serializable, Comparable<TicketWithWeight> {

    private static final long serialVersionUID = -3263156074698223503L;

    private String domainCode;
    private BigDecimal weight;
    /**
     * 广告券获取次数（指单个用户）
     * TODO 可以优化，单独抽离出来
     */
    private long count;
    private Ticket ticket;

    public TicketWithWeight() {
    }

    public TicketWithWeight(BigDecimal weight, long count, Ticket ticket) {
        this.weight = weight;
        this.count = count;
        this.ticket = ticket;
        this.domainCode = ticket.getDomainCode();
    }

    @Override
    public int compareTo(TicketWithWeight o) {
        return o.count == count ?
                (o.weight.doubleValue() > weight.doubleValue() ? 1 : -1) :
                o.count < count ? 1 : -1;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public long getCount() {
        return count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public Ticket getTicket() {
        return ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    @Override
    public String toString() {
        return new StringBuilder("[ticketId=").append(ticket.getId()).append(", weight=").append(weight).append(", count=").append(count).append(", domain=").append(domainCode).append("]").toString();
    }
}
