package com.bxm.adsprod.facade.user;

import com.bxm.warcar.utils.Constants;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;

/**
 * <h3>用户评分信息</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/06
 */
public class UserGrade implements Serializable {

    private static final long serialVersionUID = 86470458702711583L;

    private String imei;
    private Boolean valid;
    private Map<String, Grade> grades;

    /**
     * valid=true and grades isn't empty.
     * @return
     */
    public boolean isValid() {
        return null != valid && valid.booleanValue() && MapUtils.isNotEmpty(grades);
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public Boolean getValid() {
        return valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public Map<String, Grade> getGrades() {
        return grades;
    }

    public void setGrades(Map<String, Grade> grades) {
        this.grades = grades;
    }

    public static class Grade implements Serializable {

        private static final long serialVersionUID = -7641988533713009637L;
        /**
         * ticket_id
         */
        private BigInteger ruleId;
        /**
         * 是否否决
         * @see com.bxm.warcar.utils.Constants#YES
         * @see com.bxm.warcar.utils.Constants#NO
         */
        private Byte isVeto;
        private Double score;

        public BigInteger getRuleId() {
            return ruleId;
        }

        public void setRuleId(BigInteger ruleId) {
            this.ruleId = ruleId;
        }

        public Byte getIsVeto() {
            return isVeto;
        }

        public void setIsVeto(Byte isVeto) {
            this.isVeto = isVeto;
        }

        public Double getScore() {
            return score;
        }

        public void setScore(Double score) {
            this.score = score;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }
}
