/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.advertiser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.common.utils.PathUtils;
import com.bxm.adsprod.facade.advertiser.Advertiser;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.advertiser.AdvertiserConfiguration;
import com.bxm.adsprod.service.advertiser.AdvertiserServiceImpl;
import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.LifeCycle;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={AdvertiserConfiguration.class})
public class AdvertiserInitializer
extends LifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserServiceImpl.class);
    @Autowired
    private AdvertiserConfiguration configuration;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private AdvertiserService advertiserService;

    @PostConstruct
    protected void doInit() {
        if (this.isInitialized0()) {
            return;
        }
        List<Advertiser> advertisers = this.getAdvertisers();
        if (CollectionUtils.isNotEmpty(advertisers)) {
            for (final Advertiser advertiser : advertisers) {
                final BigInteger advertiserId = advertiser.getId();
                this.fetcher.hfetch(TicketKeyGenerator.Advertiser.getBalance(), String.valueOf(advertiserId), (DataExtractor)new DataExtractor<Long>(){

                    public Long extract() {
                        Long balance = AdvertiserInitializer.this.advertiserService.incrementBalance(advertiserId, Long.valueOf(advertiser.getBalance().longValue()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Initializing advertiser {} balance: {}...", (Object)advertiserId, (Object)balance);
                        }
                        return balance;
                    }
                }, Long.class);
            }
            this.finishInitialized();
        }
    }

    @PreDestroy
    protected void doDestroy() {
    }

    private boolean isInitialized0() {
        Boolean bool = (Boolean)this.fetcher.fetch(this.getInitializedKeyGenerator(), null, Boolean.class);
        return BooleanUtils.isTrue((Boolean)bool);
    }

    private void finishInitialized() {
        this.updater.update(this.getInitializedKeyGenerator(), (Object)true);
    }

    private KeyGenerator getInitializedKeyGenerator() {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "ADVERTISER", "INITIALIZED"});
            }
        };
    }

    private List<Advertiser> getAdvertisers() {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
        String url = PathUtils.appendToHost((String)this.configuration.getHost(), (Object[])new Object[]{"getList"});
        ResponseEntity entity = restTemplate.getForEntity(url, String.class, new Object[0]);
        HttpStatus statusCode = entity.getStatusCode();
        HttpHeaders headers = entity.getHeaders();
        String body = (String)entity.getBody();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Remote address {} responsed: \nstatusCode: {}\nheaders: {}", new Object[]{url, statusCode, headers});
        }
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        JSONArray list = jsonObject.getJSONArray("returnValue");
        return list.toJavaList(Advertiser.class);
    }
}

