/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.advertiser;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.ticket.event.BalanceChangedEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.EventObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Service(version="1.0.0", owner="allen")
public class AdvertiserServiceImpl
implements AdvertiserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;
    @Autowired
    private EventPark eventPark;

    public Long getAdvertiserBalance(BigInteger advertiserId) {
        return (Long)this.fetcher.hfetch(this.getKeyGenerator(), String.valueOf(advertiserId), null, Long.class);
    }

    public Long incrementBalance(BigInteger advertiserId, Long incValue) {
        Preconditions.checkNotNull((Object)advertiserId);
        Preconditions.checkNotNull((Object)incValue);
        KeyGenerator keyGenerator = this.getKeyGenerator();
        Long rst = this.counter.hincrementByAndGet(keyGenerator, String.valueOf(advertiserId), incValue.longValue());
        this.eventPark.post((EventObject)new BalanceChangedEvent(this, advertiserId, incValue, rst));
        return rst;
    }

    private KeyGenerator getKeyGenerator() {
        return TicketKeyGenerator.Advertiser.getBalance();
    }
}

