/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.commons.message;

import com.bxm.adsprod.facade.commons.MessageBody;
import com.bxm.adsprod.service.commons.message.annotation.Messaging;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendResult;
import com.bxm.warcar.utils.JsonHelper;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class MessageAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageAspect.class);
    @Autowired
    @Qualifier(value="alionsProducer")
    private Producer producer;

    @AfterReturning(pointcut="@annotation(com.bxm.adsprod.service.commons.message.annotation.Messaging)", returning="returning")
    public void doAfterReturning(JoinPoint point, Object returning) {
        Object[] args = point.getArgs();
        Method method = this.getMethod(point);
        if (null == method) {
            return;
        }
        if (null == returning) {
            return;
        }
        Messaging annotation = method.getAnnotation(Messaging.class);
        if (null == annotation) {
            return;
        }
        if (args.length > 1) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Not supported multi arguments of Method: {}", (Object)method);
            }
            return;
        }
        boolean flag = this.sendMessage(returning, args[0], annotation);
        if (!flag && LOGGER.isErrorEnabled()) {
            LOGGER.error("JoinPoint {}", (Object)point);
        }
    }

    private byte[] serialize(Object body) {
        return JsonHelper.convert2bytes((Object)body);
    }

    private boolean sendMessage(Object returning, Object request, Messaging annotation) {
        String topic = annotation.value();
        String tags = annotation.tags();
        int flag = annotation.flag();
        int delayTimeLevel = annotation.delayTimeLevel();
        MessageBody body = new MessageBody(request, returning);
        Message message = new Message(topic, tags, flag, this.serialize(body));
        message.setDelayTimeLevel(delayTimeLevel);
        try {
            SendResult result = this.producer.send(message);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Message send successful. {}", (Object)result.getMsgId());
            }
            return true;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Message send failed! ", (Throwable)e);
            }
            return false;
        }
    }

    private Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getMethod:", (Throwable)e);
            }
            return null;
        }
    }
}

