/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.commons.metrics;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ConsumeTimeMetricsAspect {
    @Autowired
    private GaugeService gaugeService;

    @Around(value="within(@com.alibaba.dubbo.config.annotation.Service *)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long start = System.currentTimeMillis();
        Object proceed = point.proceed();
        try {
            String s = point.getSignature().toShortString();
            this.gaugeService.submit(s, (double)(System.currentTimeMillis() - start));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proceed;
    }

    public void setGaugeService(GaugeService gaugeService) {
        this.gaugeService = gaugeService;
    }
}

