/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.IllegalTicketException;
import com.bxm.adsprod.facade.ticket.NoValidTicketException;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketRequest;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.service.commons.message.annotation.Messaging;
import com.bxm.adsprod.service.media.PositionService;
import com.bxm.adsprod.service.ticket.TicketRequestModel;
import com.bxm.adsprod.service.ticket.TicketWeightService;
import com.bxm.adsprod.service.ticket.filter.TicketInterceptorChain;
import com.bxm.adsprod.service.ticket.filter.TicketInterceptorInvocation;
import com.bxm.adsprod.service.user.UserService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Service(version="1.0.0", owner="allen")
public class TicketServiceImpl
implements TicketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketServiceImpl.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired(required=false)
    private TicketInterceptorChain ticketInterceptorChain;
    @Autowired
    private TicketWeightService ticketWeightService;
    @Autowired
    @Qualifier(value="userServiceImpl")
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    @Qualifier(value="ipIpNetIpLibrary")
    private IpLibrary ipLibrary;

    @Messaging(value="BXM_AD_VIEWTICKET")
    public Ticket view(TicketRequest ticketRequest) {
        List<Ticket> result;
        List<Ticket> tickets = this.getValidTickets();
        if (CollectionUtils.isEmpty(tickets)) {
            throw new NoValidTicketException();
        }
        ArrayList normals = Lists.newArrayList();
        ArrayList standbys = Lists.newArrayList();
        for (Ticket ticket : tickets) {
            if (ticket.isNormalType()) {
                normals.add(ticket);
                continue;
            }
            standbys.add(ticket);
        }
        String uid = ticketRequest.getUid();
        String ip = ticketRequest.getIp();
        TicketRequestModel requestModel = new TicketRequestModel();
        requestModel.setTickets(normals);
        requestModel.setUid(uid);
        requestModel.setImei(ticketRequest.getImei());
        requestModel.setOs(ticketRequest.getOs());
        requestModel.setIp(ip);
        requestModel.setApp(ticketRequest.getApp());
        String positionId = ticketRequest.getPosition();
        Position position = this.positionService.get(positionId);
        if (null == position) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Illegal position: {}", (Object)positionId);
            }
            throw new NoValidTicketException("Illegal position.");
        }
        requestModel.setPosition(position);
        IP iprst = this.ipLibrary.find(ip);
        if (null == iprst) {
            iprst = IP.createDefault();
        }
        requestModel.setRegionCode(iprst.getRegioncode());
        requestModel.setCity(iprst.getCity());
        TicketInterceptorInvocation invocation = new TicketInterceptorInvocation();
        invocation.setRequestModel(requestModel);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u5bf9\u5e38\u89c4\u5e7f\u544a\u5238\u8fdb\u884c\u89c4\u5219\u8fc7\u6ee4\uff0c\u5171 {} \u5f20\u3002", (Object)normals.size());
        }
        this.ticketInterceptorChain.intercept((Invocation)invocation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5e38\u89c4\u5e7f\u544a\u5238\u8fc7\u6ee4\u5b8c\u6210\uff0c\u5171 {} \u5f20\u3002", (Object)normals.size());
        }
        if (CollectionUtils.isEmpty(result = requestModel.getTickets())) {
            if (CollectionUtils.isEmpty((Collection)standbys)) {
                throw new NoValidTicketException();
            }
            return (Ticket)standbys.get(RandomUtils.nextInt((int)standbys.size()));
        }
        Ticket lastAcquiredTicket = this.userService.getLastAcquiredTicket(uid);
        return this.ticketWeightService.getBest(result, uid, lastAcquiredTicket);
    }

    @Messaging(value="BXM_AD_CLICKTICKET")
    public Ticket click(ClickRequest clickRequest) {
        BigInteger ticketId = clickRequest.getTicketId();
        Ticket ticket = this.get(ticketId);
        if (null == ticket) {
            throw new IllegalTicketException();
        }
        return ticket;
    }

    public Ticket get(BigInteger ticketId) {
        return (Ticket)this.fetcher.hfetch(TicketKeyGenerator.getAllTickets(), String.valueOf(ticketId), null, Ticket.class);
    }

    public List<Ticket> getAllTickets() {
        return this.getAllTicketsForList();
    }

    private List<Ticket> getValidTickets() {
        return this.getAllTicketsForList(true);
    }

    private List<Ticket> getAllTicketsForList() {
        return this.getAllTicketsForList(false);
    }

    private List<Ticket> getAllTicketsForList(boolean excludeNotOpenStatus) {
        return Lists.newArrayList(this.getAllTicketsForMap(excludeNotOpenStatus).values());
    }

    private Map<BigInteger, Ticket> getAllTicketsForMap(boolean excludeNotOpenStatus) {
        Map hfetchall = this.fetcher.hfetchall(TicketKeyGenerator.getAllTickets(), null, Ticket.class);
        if (MapUtils.isEmpty((Map)hfetchall)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        Set entries = hfetchall.entrySet();
        for (Map.Entry entry : entries) {
            Ticket value = (Ticket)entry.getValue();
            if (excludeNotOpenStatus && (!excludeNotOpenStatus || !value.isAvailableForStatus() || !value.isAvailableForAssets())) continue;
            result.put(TypeHelper.castToBigInteger(entry.getKey()), value);
        }
        return result;
    }
}

