/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketWithWeight;
import com.bxm.adsprod.service.ticket.TicketWeightService;
import com.bxm.adsprod.service.user.UserStatisticsService;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TicketWeightServiceImpl
implements TicketWeightService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketWeightServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private UserStatisticsService userStatisticsService;

    @Override
    public Ticket getBest(List<Ticket> tickets, String uid, Ticket last) {
        ArrayList rst = Lists.newArrayList();
        for (Ticket ticket : tickets) {
            BigInteger ticketId = ticket.getId();
            TicketWithWeight ticketWithWeight = (TicketWithWeight)this.fetcher.fetch(TicketKeyGenerator.Weight.getWeight((BigInteger)ticketId, null), null, TicketWithWeight.class);
            if (null == ticketWithWeight) {
                ticketWithWeight = new TicketWithWeight(new BigDecimal(0), 0L, ticket);
            }
            long count = this.userStatisticsService.countViewOfToday(uid, ticketId);
            ticketWithWeight.setCount(count);
            rst.add(ticketWithWeight);
        }
        Collections.sort(rst);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sorted: {}", (Object)rst);
        }
        return TicketWeightServiceImpl.getNext(rst, last).getTicket();
    }

    public static TicketWithWeight getNext(List<TicketWithWeight> tickets, Ticket last) {
        TicketWithWeight firstDifferentWithTag;
        TicketWithWeight next = tickets.get(0);
        if (last == null) {
            return next;
        }
        if (!TicketWeightServiceImpl.existsWithTag(tickets, last.getDomainCode())) {
            return next;
        }
        if (StringUtils.equals((String)last.getDomainCode(), (String)next.getDomainCode()) && null != (firstDifferentWithTag = TicketWeightServiceImpl.getFirstDifferentWithTag(tickets, last.getDomainCode()))) {
            return firstDifferentWithTag;
        }
        return next;
    }

    private static boolean existsWithTag(List<TicketWithWeight> tickets, String domainOfLast) {
        for (int index = 0; index < tickets.size(); ++index) {
            TicketWithWeight ticket = tickets.get(index);
            if (!StringUtils.equals((String)ticket.getDomainCode(), (String)domainOfLast)) continue;
            return true;
        }
        return false;
    }

    private static TicketWithWeight getFirstDifferentWithTag(List<TicketWithWeight> tickets, String domainOfLast) {
        for (int index = 0; index < tickets.size(); ++index) {
            TicketWithWeight ticket = tickets.get(index);
            if (StringUtils.equals((String)ticket.getDomainCode(), (String)domainOfLast)) continue;
            return ticket;
        }
        return null;
    }
}

