/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.service.ticket.TicketRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PositionDomainRegionInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionDomainRegionInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public PositionDomainRegionInterceptor() {
    }

    public PositionDomainRegionInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        TicketRequestModel requestModel = (TicketRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        Position position = requestModel.getPosition();
        if (null == position) {
            throw new NullPointerException("media cannot be null");
        }
        String domainCode = position.getDomainCode();
        if (StringUtils.isBlank((String)domainCode)) {
            return;
        }
        String regionCode = requestModel.getRegionCode();
        HashMap param = Maps.newHashMap();
        param.put("positionid", position.getId());
        param.put("domaincode", domainCode);
        Set rule = (Set)this.fetcher.fetch(PositionDomainRegionInterceptor.keyGenerator(param), null, Set.class);
        if (CollectionUtils.isEmpty((Collection)rule)) {
            return;
        }
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            if (!rule.contains(regionCode)) continue;
            iterator.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[PositionDomainRegionInterceptor] remove {}.", (Object)ticket.getId());
        }
    }

    public static KeyGenerator keyGenerator(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_DOMAIN", parameters.get("positionid"), parameters.get("domaincode")});
            }
        };
    }
}

