/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.alibaba.fastjson.JSONArray;
import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.service.media.PositionIdResolver;
import com.bxm.adsprod.service.ticket.TicketRequestModel;
import com.bxm.adsprod.service.ticket.filter.OldConfiguration;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.KeyBuilder;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={JedisConfiguration.class, OldConfiguration.class})
public class PositionTagRegionForOldInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionTagRegionForOldInterceptor.class);
    @Autowired
    private JedisConfiguration configuration;
    @Autowired
    private OldConfiguration oldConfiguration;
    @Autowired
    @Qualifier(value="jedisFetcherForOld")
    private Fetcher fetcher;

    protected void doIntercept(Invocation invocation) {
        TicketRequestModel requestModel = (TicketRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        String city = requestModel.getCity();
        String time = this.getTimeFromFetcher();
        if (StringUtils.isBlank((String)time)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Cloud not found 'time' value from fetcher.");
            }
            return;
        }
        Position position = requestModel.getPosition();
        String positionId = position.getId();
        String[] resolve = PositionIdResolver.DEFAULT.resolve(positionId);
        if (null == resolve || resolve.length != 2) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Illegal positionId: {}", (Object)position.getId());
            }
            return;
        }
        String appkey = resolve[0];
        String business = resolve[1];
        List<Ticket> tickets = requestModel.getTickets();
        List<BigInteger> appAreaBlack = this.getAppAreaBlack(time, KeyBuilder.build((Object[])new Object[]{appkey, business, city}));
        if (CollectionUtils.isNotEmpty(appAreaBlack)) {
            this.loopRemove(tickets, appAreaBlack, true);
            return;
        }
        List<BigInteger> appBlack = this.getAppBlack(time, KeyBuilder.build((Object[])new Object[]{appkey, business}));
        if (CollectionUtils.isNotEmpty(appBlack)) {
            this.loopRemove(tickets, appBlack, true);
            return;
        }
        List<BigInteger> appWhite = this.getAppWhite(time, KeyBuilder.build((Object[])new Object[]{appkey, business}));
        if (CollectionUtils.isNotEmpty(appWhite)) {
            this.loopRemove(tickets, appWhite, false);
            return;
        }
    }

    private void loopRemove(List<Ticket> tickets, List<BigInteger> cache, boolean blacklist) {
        Iterator<Ticket> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            if ((!blacklist || !cache.contains(ticketId)) && (blacklist || cache.contains(ticketId))) continue;
            iterator.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[PositionTagRegionForOldInterceptor] remove {}.", (Object)ticketId);
        }
    }

    private String getTimeFromFetcher() {
        return (String)this.fetcher.fetch(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"time", "black"});
            }
        }, null, String.class);
    }

    private List<BigInteger> getAppAreaBlack(final String time, String field) {
        String cache = (String)this.fetcher.hfetch(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"app_area", "black", time});
            }
        }, field, null, String.class);
        if (StringUtils.isBlank((String)cache)) {
            return null;
        }
        return JSONArray.parseArray((String)cache, BigInteger.class);
    }

    private List<BigInteger> getAppBlack(final String time, String field) {
        String cache = (String)this.fetcher.hfetch(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"app", "black", time});
            }
        }, field, null, String.class);
        if (StringUtils.isBlank((String)cache)) {
            return null;
        }
        return JSONArray.parseArray((String)cache, BigInteger.class);
    }

    private List<BigInteger> getAppWhite(final String time, String field) {
        String cache = (String)this.fetcher.hfetch(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"app", "white", time});
            }
        }, field, null, String.class);
        if (StringUtils.isBlank((String)cache)) {
            return null;
        }
        return JSONArray.parseArray((String)cache, BigInteger.class);
    }

    @Bean
    public JedisPool jedisPoolForOld() {
        return new JedisPool((GenericObjectPoolConfig)this.configuration, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getTimeout(), this.configuration.getPassword(), this.oldConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcherForOld() {
        return new JedisFetcher(this.jedisPoolForOld());
    }
}

