/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.service.ticket.filter.PositionDomainRegionInterceptor;
import com.bxm.adsprod.service.ticket.filter.PositionTagRegionForOldInterceptor;
import com.bxm.adsprod.service.ticket.filter.PositionTagRegionInterceptor;
import com.bxm.adsprod.service.ticket.filter.SelfProdInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketPositionInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketRegionInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketTimelineInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketTimesInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketUserGradeInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketUserOsInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketUserWechatInterceptor;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public final class TicketInterceptorChain
implements Interceptor,
ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private TicketRegionInterceptor ticketRegionInterceptor;
    @Autowired
    private TicketUserOsInterceptor ticketUserOsInterceptor;
    @Autowired
    private TicketUserWechatInterceptor ticketUserWechatInterceptor;
    @Autowired
    private TicketPositionInterceptor ticketPositionInterceptor;
    @Autowired
    private TicketTimelineInterceptor ticketTimelineInterceptor;
    @Autowired
    private PositionDomainRegionInterceptor positionDomainRegionInterceptor;
    @Autowired
    private PositionTagRegionInterceptor positionTagRegionInterceptor;
    @Autowired
    private PositionTagRegionForOldInterceptor positionTagRegionForOldInterceptor;
    @Autowired
    private SelfProdInterceptor selfProdInterceptor;
    @Autowired
    private TicketTimesInterceptor ticketTimesInterceptor;
    @Autowired
    private TicketUserGradeInterceptor ticketUserGradeInterceptor;
    private final List<Interceptor> interceptors = Lists.newArrayList();

    private void addInterceptors() {
        this.interceptors.add((Interceptor)this.ticketUserOsInterceptor);
        this.interceptors.add((Interceptor)this.ticketUserWechatInterceptor);
        this.interceptors.add((Interceptor)this.ticketRegionInterceptor);
        this.interceptors.add((Interceptor)this.ticketPositionInterceptor);
        this.interceptors.add((Interceptor)this.ticketTimelineInterceptor);
        this.interceptors.add((Interceptor)this.positionDomainRegionInterceptor);
        this.interceptors.add((Interceptor)this.positionTagRegionInterceptor);
        this.interceptors.add((Interceptor)this.positionTagRegionForOldInterceptor);
        this.interceptors.add((Interceptor)this.selfProdInterceptor);
        this.interceptors.add((Interceptor)this.ticketTimesInterceptor);
        this.interceptors.add((Interceptor)this.ticketUserGradeInterceptor);
        for (int i = 0; i < this.interceptors.size(); ++i) {
            boolean isLast;
            Interceptor interceptor = this.interceptors.get(i);
            if (!(interceptor instanceof AbstractInterceptor)) continue;
            boolean bl = isLast = i + 1 == this.interceptors.size();
            if (isLast) continue;
            ((AbstractInterceptor)interceptor).setNextInterceptor(this.interceptors.get(i + 1));
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (null == event.getApplicationContext().getParent()) {
            this.addInterceptors();
        }
    }

    public void intercept(Invocation invocation) {
        this.interceptors.get(0).intercept(invocation);
    }
}

