/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.model.so.rules.TicketPositionRuleSo;
import com.bxm.adsprod.service.ticket.TicketRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketPositionInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketPositionInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public TicketPositionInterceptor() {
    }

    public TicketPositionInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        TicketRequestModel requestModel = (TicketRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            HashMap parameters = Maps.newHashMap();
            parameters.put("ticketid", ticketId);
            TicketPositionRuleSo rule = (TicketPositionRuleSo)this.fetcher.fetch(TicketPositionInterceptor.keyGenerator(parameters), null, TicketPositionRuleSo.class);
            if (null == rule || (!rule.isBlackList() || !rule.getPositions().contains(ticketId)) && (rule.isBlackList() || rule.getPositions().contains(ticketId))) continue;
            iterator.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[TicketPositionInterceptor] remove {}.", (Object)ticketId);
        }
    }

    public static KeyGenerator keyGenerator(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", parameters.get("ticketid")});
            }
        };
    }
}

