/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.service.ticket.TicketRequestModel;
import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketRegionInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketRegionInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public TicketRegionInterceptor() {
    }

    public TicketRegionInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        TicketRequestModel requestModel = (TicketRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        String regionCode = requestModel.getRegionCode();
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            DataExtractor dataExtractor;
            Ticket ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            HashMap parameters = Maps.newHashMap();
            parameters.put("ticketid", ticketId);
            KeyGenerator keyGenerator = TicketRegionInterceptor.keyGenerator(parameters);
            Set closeRegion = (Set)this.fetcher.fetch(keyGenerator, dataExtractor = this.getDataExtractor(parameters), Set.class);
            if (CollectionUtils.isEmpty((Collection)closeRegion) || !closeRegion.contains(regionCode)) continue;
            iterator.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[TicketRegionInterceptor] remove {}.", (Object)ticketId);
        }
    }

    private DataExtractor getDataExtractor(Map<String, Object> parameters) {
        return new DataExtractor<Set<String>>(){

            public Set<String> extract() {
                return null;
            }
        };
    }

    public static KeyGenerator keyGenerator(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                Object ticketId = parameters.get("ticketid");
                return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "REGION", ticketId});
            }
        };
    }
}

