/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.model.so.rules.TicketTimelineRuleSo;
import com.bxm.adsprod.service.ticket.TicketRequestModel;
import com.bxm.adsprod.service.ticket.event.DailyBudgetNotEnoughEvent;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketTimelineInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketTimelineInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired(required=false)
    private TicketStatisticsService ticketStatisticsService;
    @Autowired
    private EventPark eventPark;

    public TicketTimelineInterceptor() {
    }

    public TicketTimelineInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        TicketRequestModel requestModel = (TicketRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        int currentHour = Calendar.getInstance().get(11);
        block0: while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            HashMap parameters = Maps.newHashMap();
            BigInteger ticketId = ticket.getId();
            parameters.put("ticketid", ticketId);
            TicketTimelineRuleSo rule = (TicketTimelineRuleSo)this.fetcher.fetch(TicketTimelineInterceptor.keyGenerator(parameters), null, TicketTimelineRuleSo.class);
            if (null == rule) {
                Integer ticketBudgetDaily;
                long budgetOfToday = this.ticketStatisticsService.getBudgetOfToday(ticketId);
                if (budgetOfToday < (long)(ticketBudgetDaily = ticket.getBudgetDaily()).intValue()) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[TicketTimelineInterceptor] removed [{}], Because out of daily budget {}/{}\u3002", new Object[]{ticketId, budgetOfToday, ticketBudgetDaily});
                }
                iterator.remove();
                this.eventPark.post((EventObject)new DailyBudgetNotEnoughEvent((Object)this, ticket));
                continue;
            }
            List entries = rule.getEntries();
            for (TicketTimelineRuleSo.Entry entry : entries) {
                long budgetOfTimeline;
                int startHour = entry.getStartHour();
                int endHour = entry.getEndHour();
                long max = entry.getLimit();
                boolean isNow = startHour >= currentHour && currentHour <= endHour;
                if (!isNow || (budgetOfTimeline = this.ticketStatisticsService.getBudgetOfTimeline(ticketId, startHour, endHour)) < max) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[TicketTimelineInterceptor] remove [{}], Because out of current time [{}-{}] budget {}/{}\u3002", new Object[]{ticketId, startHour, endHour, budgetOfTimeline, max});
                }
                iterator.remove();
                continue block0;
            }
        }
    }

    public static KeyGenerator keyGenerator(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TIMELINE", parameters.get("ticketid")});
            }
        };
    }
}

