/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.model.so.rules.TicketTimesRuleSo;
import com.bxm.adsprod.service.ticket.TicketRequestModel;
import com.bxm.adsprod.service.ticket.filter.times.TimesRuleProcessor;
import com.bxm.adsprod.service.ticket.filter.times.TimesRuleProcessorFactory;
import com.bxm.adsprod.service.user.UserService;
import com.bxm.adsprod.service.user.UserStatisticsService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketTimesInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketTimesInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired(required=false)
    private UserService userService;
    @Autowired(required=false)
    private UserStatisticsService userStatisticsService;

    public TicketTimesInterceptor() {
    }

    public TicketTimesInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        TicketRequestModel requestModel = (TicketRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        String uid = requestModel.getUid();
        if (StringUtils.isBlank((String)uid)) {
            throw new NullPointerException("uid cannot be blank");
        }
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        block0: while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            HashMap parameters = Maps.newHashMap();
            parameters.put("ticketid", ticketId);
            TicketTimesRuleSo rule = (TicketTimesRuleSo)this.fetcher.fetch(TicketTimesInterceptor.keyGenerator(parameters), null, TicketTimesRuleSo.class);
            if (null == rule) continue;
            List entries = rule.getEntries();
            for (TicketTimesRuleSo.Entry entry : entries) {
                TimesRuleProcessor processor = TimesRuleProcessorFactory.create(this.userStatisticsService, entry);
                if (!processor.isOutOfTimes(uid, ticketId)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[TicketTimesInterceptor] remove {}.", (Object)ticketId);
                }
                iterator.remove();
                continue block0;
            }
        }
    }

    public static KeyGenerator keyGenerator(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TIMES", parameters.get("ticketid")});
            }
        };
    }
}

