/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketOnoff;
import com.bxm.adsprod.facade.user.UserGrade;
import com.bxm.adsprod.service.ticket.TicketRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketUserGradeInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketUserGradeInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public TicketUserGradeInterceptor() {
    }

    public TicketUserGradeInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        TicketRequestModel requestModel = (TicketRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        UserGrade userGrade = null;
        if (!requestModel.isNoImei()) {
            String imei = requestModel.getImei();
            HashMap parameters = Maps.newHashMap();
            parameters.put("imei", imei);
            userGrade = (UserGrade)this.fetcher.fetch(TicketUserGradeInterceptor.keyGenerator(parameters), null, UserGrade.class);
        }
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            int i;
            Double score;
            UserGrade.Grade grade;
            Ticket ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            List onoffs = ticket.getOnoffs();
            if (CollectionUtils.isEmpty((Collection)onoffs)) continue;
            if (requestModel.isNoImei()) {
                if (!this.removeForPercent(iterator, onoffs, 1)) continue;
                this.debugRemoved(ticketId);
                continue;
            }
            if (null == userGrade || !userGrade.isValid()) {
                if (!this.removeForPercent(iterator, onoffs, 2)) continue;
                this.debugRemoved(ticketId);
                continue;
            }
            Map grades = userGrade.getGrades();
            if (MapUtils.isEmpty((Map)grades) || null == (grade = (UserGrade.Grade)grades.get(ticketId))) continue;
            Byte isVeto = grade.getIsVeto();
            double resetScore = this.resetScore(isVeto, score = grade.getScore());
            if (resetScore <= 0.0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[TicketUserGradeInterceptor] \u5e7f\u544a\u5238[{}]\u7528\u6237[{}]\u753b\u50cf\u4fe1\u606f[{}]\u88ab\u5426\u51b3\u3002", new Object[]{ticketId, userGrade.getImei(), grade});
                }
                iterator.remove();
                continue;
            }
            Integer passScore = ticket.getUserGradePassScore();
            if (null == passScore || !(resetScore < (double)(i = passScore.intValue()))) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[TicketUserGradeInterceptor] \u5e7f\u544a\u5238[{}]\u7528\u6237[{}]\u753b\u50cf\u4fe1\u606f[{}]\u5f97\u5206{}<{}\u4e0d\u53ca\u683c\u3002", new Object[]{ticketId, userGrade.getImei(), grade, resetScore, i});
            }
            iterator.remove();
        }
    }

    private void debugRemoved(BigInteger ticketId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[TicketUserGradeInterceptor] remove {}.", (Object)ticketId);
        }
    }

    private boolean removeForPercent(Iterator<Ticket> iterator, List<TicketOnoff> onoffs, int type) {
        TicketOnoff conf = this.getFirstItemForType(onoffs, 2);
        if (null == conf) {
            iterator.remove();
            return true;
        }
        String value = conf.getValue();
        int percent = NumberUtils.toInt((String)value, (int)0);
        if (percent > this.random()) {
            iterator.remove();
            return true;
        }
        return false;
    }

    private int random() {
        return RandomUtils.nextInt((int)100) + 1;
    }

    private TicketOnoff getFirstItemForType(List<TicketOnoff> onoffs, int type) {
        for (TicketOnoff onoff : onoffs) {
            Integer t = onoff.getType();
            if (null == t || type != t) continue;
            return onoff;
        }
        return null;
    }

    private double resetScore(Byte isVeto, Double score) {
        if (null == isVeto || null == score) {
            return 0.0;
        }
        double rs = score;
        byte veto = isVeto;
        if (rs == -1.0) {
            return 0.0;
        }
        return rs * (double)(veto == 1 ? -1 : 1);
    }

    public static KeyGenerator keyGenerator(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "USER", parameters.get("imei")});
            }
        };
    }
}

